---
title: Extended DNS error codes · Cloudflare 1.1.1.1 docs
description: Extended DNS Error Codes is a method to return additional
  information about the cause of DNS errors. As there are many reasons why a DNS
  query might fail, it became necessary to provide additional information on the
  exact cause of an error.
lastUpdated: 2024-12-05T10:44:03.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/1.1.1.1/infrastructure/extended-dns-error-codes/
  md: https://developers.cloudflare.com/1.1.1.1/infrastructure/extended-dns-error-codes/index.md
---

[Extended DNS Error Codes](https://www.rfc-editor.org/rfc/rfc8914.html) is a method to return additional information about the cause of DNS errors. As there are many reasons why a DNS query might fail, it became necessary to provide additional information on the exact cause of an error.

1.1.1.1 supports Extended DNS Error Codes. Below is a list of error codes 1.1.1.1 returns, what they mean, and steps you may want to take to resolve the issue.

| Code number | Code name | Example output | Next steps |
| - | - | - | - |
| 1 | Unsupported DNSKEY Algorithm | `EDE: 1 (Unsupported DNSKEY Algorithm): (failed to verify example.com. A: unsupported key size, DNSKEY example.com., id = 12345)` | The domain did not pass DNSSEC validation. Check which [signature key algorithm](https://developers.cloudflare.com/1.1.1.1/encryption/dnskey/) your website uses and confirm it is supported by 1.1.1.1. |
| 2 | Unsupported DS Digest Type | `EDE: 2 (Unsupported DS Digest Type): (no supported DS digest type for example.com.)` | The domain did not pass DNSSEC validation due to an unsupported digest type on the DS record. If none of the provided DS records are supported, the domain will fail to resolve. Make sure to [add a supported DS record](https://developers.cloudflare.com/dns/dnssec/) with your registrar. |
| 3 | Stale Answer | `EDE: 3 (Stale Answer)` | This is a silent error. It notifies that the DNS resolver could only return stale data. If the issue persists reach out on the 1.1.1.1 [community forum](https://community.cloudflare.com/c/reliability/dns-1111/47). |
| 6 | DNSSEC Bogus | `EDE: 6 (DNSSEC Bogus): (proof of non-existence of example.com. A)` `EDE: 6 (DNSSEC Bogus): (found duplicate CNAME records for example.com. (1 duplicate RRs))` | This domain did not pass DNSSEC validation. The signatures for the target record, or the proof of non-existence of the target records, are invalid. Check your [DNS configuration](https://developers.cloudflare.com/dns/). |
| 7 | Signature Expired | `EDE: 7 (Signature Expired): (for DNSKEY example.com., id = 12345: RRSIG example.com., expiration = 123456)` | This domain did not pass DNSSEC validation due to an expired signature. Make sure your zone is signed with valid [DNSSEC signatures](https://developers.cloudflare.com/dns/dnssec/troubleshooting/). |
| 8 | Signature Not Yet Valid | `EDE: 8 (Signature Not Yet Valid): (for DNSKEY example.com., id = 12345: RRSIG example.com., inception = 12345)` | This domain did not pass DNSSEC validation. Make sure your zone is signed with valid [DNSSEC signatures](https://developers.cloudflare.com/dns/dnssec/troubleshooting/). |
| 9 | DNSKEY Missing | `EDE: 9 (DNSKEY Missing): (no SEP matching the DS found for example.com.)` | This domain did not pass DNSSEC validation. It does not have a SEP DNSKEY that matches the set of DS records at the registry. Make sure to either sign the zone using keys that match the current DS set, or [add the missing DS records](https://developers.cloudflare.com/dns/dnssec/) with your registrar. |
| 10 | RRSIGs Missing | `EDE: 10 (RRSIGs Missing): (for DNSKEY example.com., id = 12345)` | 1.1.1.1 was unable to retrieve Resource Record Signatures (RRSigs) to verify the authenticity of the records. Check your [DNS configuration](https://developers.cloudflare.com/dns/) and the response code. If the response code is not `SERVFAIL`, this error indicates that there is a non-operational key issue somewhere along the path, but the resolver found at least one successful path for validation. Examples of non-operational key issues include but are not limited to key rollover in-progress, stand-by key, and attacker stripping signatures made by a certain key. |
| 11 | No Zone Key Bit Set | `EDE: 11 (No Zone Key Bit Set): (for DNSKEY example.com., id = 12345)` | This domain did not pass DNSSEC validation. The zone's SEP DNSKEY must [set a Zone Key flag](https://datatracker.ietf.org/doc/html/rfc4035#section-5.3.1). Check your [DNSSEC configuration](https://developers.cloudflare.com/dns/dnssec/) or DNSSEC's [troubleshooting guide](https://developers.cloudflare.com/dns/dnssec/troubleshooting/). |
| 12 | NSEC Missing | `EDE: 12 (NSEC Missing): failed to verify an insecure referral proof for example.com` | This domain did not pass DNSSEC validation. The upstream nameserver did not include a valid proof of non-existence for the target name. Make sure the zone is [signed with DNSSEC](https://developers.cloudflare.com/dns/dnssec/troubleshooting/) and has valid [NSEC/NSEC3 records](https://www.cloudflare.com/dns/dnssec/dnssec-complexities-and-considerations/). |
| 13 | Cached Error | `EDE: 13 (Cached Error)` | 1.1.1.1 returned a cached error. If this issue persists, reach out to the [community forum](https://community.cloudflare.com/c/reliability/dns-1111/47). |
| 22 | No Reachable Authority | `EDE: 22 (No Reachable Authority): (at delegation example.com.)` | 1.1.1.1 could not reach some or all of the authoritative nameservers (or they potentially refused to resolve). This can occur if the authoritative nameservers are overloaded or temporarily unavailable. If this issue persists, reach out to the [community forum](https://community.cloudflare.com/c/reliability/dns-1111/47). |
| 23 | Network Error | `EDE: 23 (Network Error): (1.1.1.1:53 rcode=SERVFAIL for example.com. A)` | 1.1.1.1 could not determine a network path to the upstream nameservers, or the nameserver did not respond. If this issue persists, reach out to the [community forum](https://community.cloudflare.com/c/reliability/dns-1111/47). |
| 30 | Invalid Query Type | `EDE: 30 (Invalid Query Type): Invalid Query Type` | The record type in the request cannot give a valid answer. If this is returned for standard query types, such as A or AAAA records, please reach out to the [community forum](https://community.cloudflare.com/c/reliability/dns-1111/47). |
