---
title: Resolve "cannot remove payment method" · Cloudflare Billing docs
description: "This article will help if you are receiving an error that mentions
  one of the following errors when attempting to remove a payment method:"
lastUpdated: 2025-08-21T17:26:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/billing/resolve-cannot-remove-payment-method/
  md: https://developers.cloudflare.com/billing/resolve-cannot-remove-payment-method/index.md
---

This article will help if you are receiving an error that mentions one of the following errors when attempting to remove a payment method:

* "Cannot remove payment method from account with active subscriptions."
* "unable to remove payment method from account with transactions in progress"

## Causes

* You still have active paid subscriptions
* You have cancelled your paid subscriptions, but a usage-based charge is still scheduled
* You have an upcoming Registrar domain registration renewal within the next 24 hours

## Solutions

You can resolve this by checking your account for each of the potential causes.

### Check for active paid subscriptions

You can only remove your payment method once all your paid subscriptions and outstanding charges have been completed. To check your paid subscriptions are cancelled follow this:

1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account.
2. Go to **Manage Account > Billing**.
3. Go to **Subscriptions**.
4. Check **Service status** for any which are marked “Active”
5. Click the “Cancel” button

You must complete this for all active paid subscriptions before you will be able to remove your card.

### Check for Usage Based products

If you have cancelled all of your paid products & subscriptions, any usage based products cancelled within the last 30 days may still generate charges. We require that your payment method remains on file until those potential usage charges have been processed. As such, if you recently cancelled any of the following products, you will need to wait 30 days before you can remove your payment method:

* Images
* Stream
* Workers
* Argo
* Spectrum
* R2
* Cache Reserve
* Load Balancing
* Rate Limiting
* Log Explorer
* Zero Trust
* Vectorize
* Analytics

Once your next monthly invoice has been produced you should be able to remove your card.

### Check for an upcoming Registrar renewal

For Registrar domains scheduled for auto-renewal, we will attempt to renew approximately 30 days before your renewal date. In the 24 hours prior to that, we will automatically process a payment hold using your payment method. During this time you will be unable to remove your payment method.

To check if any of your domains are in the process of renewal:

1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account.
2. Go to **Domain Registration > Manage Domains**.
3. Under the **Expires** column, look for any domains expiring within the next 31 days which have Auto-renew enabled.

If you have any domains with auto-renew enabled that are expiring in 31 days or less, you will need to wait for them to renew before you can remove your payment method. To understand more about this process, refer to [renew domains](https://developers.cloudflare.com/registrar/account-options/renew-domains/).

### If none of the above apply

If you have confirmed all of the above do not apply in your case and you still receive an error message when attempting to remove your payment method, please [contact support](https://developers.cloudflare.com/support/contacting-cloudflare-support/).
