---
title: Bot Management skips · Cloudflare bot solutions docs
description: There are instances in which Bot Management does not run and
  certain fields, such as the JA3/JA4 field, are not populated because it has
  been determined that running Bot Management would not be necessary.
lastUpdated: 2025-04-03T20:17:30.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/bots/troubleshooting/bot-management-skips/
  md: https://developers.cloudflare.com/bots/troubleshooting/bot-management-skips/index.md
---

There are instances in which Bot Management does not run and certain fields, such as the [JA3/JA4 field](https://developers.cloudflare.com/bots/additional-configurations/ja3-ja4-fingerprint/), are not populated because it has been determined that running Bot Management would not be necessary.

Refer to [bot scores](https://developers.cloudflare.com/bots/concepts/bot-score/#not-computed) for more information about why a request is not scored.

## Common reasons for Bot Management to not score a request

### Requests to internal endpoints

Requests such as `/cdn-cgi/` are handled individually and will never receive a Bot Management score. Email Obfuscation, Web Analytics, Trace Requests, Challenge Pages, and JavaScript Detections do not receive bot scores. Refer to the table below for some examples of internal endpoints.

| Route |
| - |
| `/cdn-cgi/rum` |
| `/cdn-cgi/script_monitor/report` |
| `/cdn-cgi/trace` |
| `/cdn-cgi/challenge-platform/…` |
| `/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js` |

### Purge requests

All HTTP purge requests will not receive a bot score.

### Early hints cache requests

Early hints cache requests will not receive a bot score.
