---
title: Manage IRR entries · Cloudflare BYOIP docs
description: You must keep your Internet Routing Registry (IRR) entries up to
  date so that it is public information that Cloudflare has permission to
  advertise your prefix or prefixes, and to ensure that your traffic can be
  properly routed on the internet.
lastUpdated: 2025-10-30T18:03:49.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/byoip/concepts/irr-entries/best-practices/
  md: https://developers.cloudflare.com/byoip/concepts/irr-entries/best-practices/index.md
---

You must keep your [Internet Routing Registry (IRR)](https://developers.cloudflare.com/byoip/concepts/irr-entries/) entries up to date so that it is public information that Cloudflare has permission to advertise your prefix or prefixes, and to ensure that your traffic can be properly routed on the internet.

## Configure an IRR entry

You can add or update an IRR entry by following the directions of your routing registry. Each routing registry has its own set of instructions to configure an IRR entry.

The recommended registries are AFRINIC, APNIC, ARIN, LACNIC, and RIPE. Refer to the table below for more information.

| Route registry | URL |
| - | - |
| AFRINIC | [](https://afrinic.net/internet-routing-registry#guide)<https://afrinic.net/internet-routing-registry#guide> |
| APNIC | [](https://www.apnic.net/manage-ip/apnic-services/routing-registry/)<https://www.apnic.net/manage-ip/apnic-services/routing-registry/> |
| ARIN | [](https://www.arin.net/resources/manage/irr/quickstart/)<https://www.arin.net/resources/manage/irr/quickstart/> |
| LACNIC | [](https://lacnic.zendesk.com/hc/articles/360038667154-What-are-a-route-and-a-route-6-objects)<https://lacnic.zendesk.com/hc/articles/360038667154-What-are-a-route-and-a-route-6-objects> |
| RIPE | [](https://www.ripe.net/manage-ips-and-asns/db/support/managing-route-objects-in-the-irr)<https://www.ripe.net/manage-ips-and-asns/db/support/managing-route-objects-in-the-irr> |

## Verify an IRR entry

Verify your Internet Routing Registry (IRR) entries to ensure that the IP prefixes Cloudflare advertises for you match the correct autonomous system numbers (ASNs).

Each IRR entry record must include the following information:

* **Route**: Each IP prefix Cloudflare advertises for you.
* **Origin ASN**: The Cloudflare ASN (AS13335) or your own ASN.
* **Source**: The name of the routing registry (for example, ARIN).

Add or update IRR entries when they meet any of these criteria:

* The entry is missing.
* The entry is incomplete or inaccurate — for example, when the route object does not show the correct origin.
* The entry is complete but requires updating — for example, when they correspond to supernets but need to correspond to subnets used in Magic Transit.

### IRR entry verification methods

To verify your prefix and ASN route, use the tools and methods outlined on the table below:

| Data to verify | Tool | Method | Output |
| - | - | - | - |
| Subnet prefix IP for the ASN | [IRR Explorer](< https://irrexplorer.nlnog.net>) | Search for the subnet prefix IP, for example, `162.211.156.0/24`. | List of ASN numbers, source (route registry), and any associated errors. |
| ASN for the subnet prefix | [IRR Explorer](< https://irrexplorer.nlnog.net>) | Search for the ASN, for example `AS13335`. | List of prefixes, source, and any associated errors. |
| Your origin ASN and routing data | WHOIS lookup | In a terminal, use this `whois` command, substituting your network prefix for *network-prefix*:`whois -h rr.ntt.net network-prefix`The host `rr.ntt.net` is the primary server for the Global IP network. | IRR route, origin, and source information. |

#### WHOIS output

The `<IRR entry section>` in the WHOIS output shows the correct IRR entry information for the specified network. In this example, the network prefix is `1.1.1.0/24`, and the output includes the route, origin ASN, and route registry, which in this example is APNIC:

```txt
user@xxt32z conduit-qs-config % whois -h rr.ntt.net 1.1.1.0/24
route:          1.1.1.0/24
<RPKI section>
descr:          RPKI ROA for 1.1.1.0/24
remarks:        This route object represents routing data retrieved from the RPKI
remarks:        The original data can be found here: https://rpki.gin.ntt.net/r/AS13335/1.1.1.0/24
remarks:        This route object is the result of an automated RPKI-to-IRR conversion process.
remarks:        maxLength 24
origin:         AS13335
mnt-by:         MAINT-NTTCOM-RPKI
changed:        job@ntt.net 20200913
source:         RPKI  # Trust Anchor: apnic


<IRR entry section>
route:          1.1.1.0/24
origin:         AS13335
descr:          APNIC Research and Development
                6 Cordelia St
mnt-by:         MAINT-AU-APNIC-GM85-AP
last-modified:  2018-03-16T16:58:06Z
source:         APNIC
```

Note

WHOIS output also shows the RPKI entry information for prefix IP addresses. When your WHOIS output only contains an RPKI entry, you must add the IRR entry.
