---
title: Eliminate long-lived credentials and enhance SSH security with Cloudflare
  Access for Infrastructure · Changelog
description: Use short-lived SSH certificates and fine-grained policy to secure
  access to your SSH servers.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2024-10-01-ssh-with-access-for-infrastructure/
  md: https://developers.cloudflare.com/changelog/2024-10-01-ssh-with-access-for-infrastructure/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Eliminate long-lived credentials and enhance SSH security with Cloudflare Access for Infrastructure

Oct 01, 2024

[Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

Organizations can now eliminate long-lived credentials from their SSH setup and enable strong multi-factor authentication for SSH access, similar to other Access applications, all while generating access and command logs.

SSH with [Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/infrastructure-apps/) uses short-lived SSH certificates from Cloudflare, eliminating SSH key management and reducing the security risks associated with lost or stolen keys. It also leverages a common deployment model for Cloudflare One customers: [WARP-to-Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-warp-to-tunnel/).

SSH with Access for Infrastructure enables you to:

* **Author fine-grained policy** to control who may access your SSH servers, including specific ports, protocols, and SSH users.
* **Monitor infrastructure access** with Access and SSH command logs, supporting regulatory compliance and providing visibility in case of security breach.
* **Preserve your end users' workflows.** SSH with Access for Infrastructure supports native SSH clients and does not require any modifications to users’ SSH configs.

![Example of an infrastructure Access application](https://developers.cloudflare.com/_astro/infrastructure-app.BhpJOgxs_Z1Ixiie.webp)

To get started, refer to [SSH with Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/).
