---
title: 40-60% Faster D1 Worker API Requests · Changelog
description: D1's Worker API request latency decreases by 40-60%.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-01-07-d1-faster-query/
  md: https://developers.cloudflare.com/changelog/2025-01-07-d1-faster-query/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## 40-60% Faster D1 Worker API Requests

Jan 07, 2025

[D1](https://developers.cloudflare.com/d1/)

Users making [D1](https://developers.cloudflare.com/d1/) requests via the [Workers API](https://developers.cloudflare.com/d1/worker-api/) can see up to a 60% end-to-end latency improvement due to the removal of redundant network round trips needed for each request to a D1 database.

![D1 Worker API latency](https://developers.cloudflare.com/_astro/faster-d1-worker-api.4S7VSUdP_o2jsC.webp)

*p50, p90, and p95 request latency aggregated across entire D1 service. These latencies are a reference point and should not be viewed as your exact workload improvement.*

This performance improvement benefits all D1 Worker API traffic, especially cross-region requests where network latency is an outsized latency factor. For example, a user in Europe talking to a database in North America. D1 [location hints](https://developers.cloudflare.com/d1/configuration/data-location/#provide-a-location-hint) can be used to influence the geographic location of a database.

For more details on how D1 removed redundant round trips, see the D1 specific release note [entry](https://developers.cloudflare.com/d1/platform/release-notes/#2025-01-07).
