---
title: View custom metadata in responses and guide AI-search with context in
  AutoRAG · Changelog
description: You can now view custom metadata in AutoRAG search responses and
  use a context field to provide additional guidance to AI-generated answers.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-06-19-autorag-custom-metadata-and-context/
  md: https://developers.cloudflare.com/changelog/2025-06-19-autorag-custom-metadata-and-context/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## View custom metadata in responses and guide AI-search with context in AutoRAG

Jun 19, 2025

[AI Search](https://developers.cloudflare.com/ai-search/)

In [AutoRAG](https://developers.cloudflare.com/ai-search/), you can now view your object's custom metadata in the response from [`/search`](https://developers.cloudflare.com/ai-search/usage/workers-binding/) and [`/ai-search`](https://developers.cloudflare.com/ai-search/usage/workers-binding/), and optionally add a `context` field in the custom metadata of an object to provide additional guidance for AI-generated answers.

You can add [custom metadata](https://developers.cloudflare.com/r2/api/workers/workers-api-reference/#r2putoptions) to an object when uploading it to your R2 bucket.

#### Object's custom metadata in search responses

When you run a search, AutoRAG now returns any custom metadata associated with the object. This metadata appears in the response inside `attributes` then `file` , and can be used for downstream processing.

For example, the `attributes` section of your search response may look like:

```json
{
  "attributes": {
    "timestamp": 1750001460000,
    "folder": "docs/",
    "filename": "launch-checklist.md",
    "file": {
      "url": "https://wiki.company.com/docs/launch-checklist",
      "context": "A checklist for internal launch readiness, including legal, engineering, and marketing steps."
    }
  }
}
```

#### Add a `context` field to guide LLM answers

When you include a custom metadata field named `context`, AutoRAG attaches that value to each chunk of the file. When you run an `/ai-search` query, this `context` is passed to the LLM and can be used as additional input when generating an answer.

We recommend using the `context` field to describe supplemental information you want the LLM to consider, such as a summary of the document or a source URL. If you have several different metadata attributes, you can join them together however you choose within the `context` string.

For example:

```json
{
  "context": "summary: 'Checklist for internal product launch readiness, including legal, engineering, and marketing steps.'; url: 'https://wiki.company.com/docs/launch-checklist'"
}
```

This gives you more control over how your content is interpreted, without requiring you to modify the original contents of the file.

Learn more in AutoRAG's [metadata filtering documentation](https://developers.cloudflare.com/ai-search/configuration/metadata).
