---
title: "Workers AI Markdown Conversion: New endpoint to list supported formats ·
  Changelog"
description: You can now programmatically get a list of all supported file
  formats that can be converted by our Markdown Conversion utility.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-10-23-new-markdown-conversion-endpoint/
  md: https://developers.cloudflare.com/changelog/2025-10-23-new-markdown-conversion-endpoint/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Workers AI Markdown Conversion: New endpoint to list supported formats

Oct 23, 2025

[Workers AI](https://developers.cloudflare.com/workers-ai/)

Developers can now programmatically retrieve a list of all file formats supported by the [Markdown Conversion utility](https://developers.cloudflare.com/workers-ai/features/markdown-conversion/) in Workers AI.

You can use the [`env.AI`](https://developers.cloudflare.com/workers-ai/configuration/bindings/) binding:

```typescript
await env.AI.toMarkdown().supported()
```

Or call the REST API:

```bash
curl https://api.cloudflare.com/client/v4/accounts/{ACCOUNT_ID}/ai/tomarkdown/supported \
  -H 'Authorization: Bearer {API_TOKEN}'
```

Both return a list of file formats that users can convert into Markdown:

```json
[
  {
    "extension": ".pdf",
    "mimeType": "application/pdf",
  },
  {
    "extension": ".jpeg",
    "mimeType": "image/jpeg",
  },
  ...
]
```

Learn more about our [Markdown Conversion utility](https://developers.cloudflare.com/workers-ai/features/markdown-conversion/).
