---
title: Reclassifications · Cloudflare One docs
description: Reclassifying messages allows you to choose the disposition of your
  messages if the disposition is incorrect. This helps improve Email security's
  detection accuracy and ensures proper handling of email threats.
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/reclassifications/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/reclassifications/index.md
---

Reclassifying messages allows you to choose the disposition of your messages if the disposition is incorrect. This helps improve Email security's detection accuracy and ensures proper handling of email threats.

## Reclassify messages

To reclassify a message:

1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Email security** and select **Investigation**.

2. On the **Investigation** page, under **Your matching messages**, select the message you want to reclassify.

3. Select the three dots, then select **Request reclassification**.

4. Under **New disposition**, select among the following:

   * **Malicious**: Traffic invoked multiple phishing verdict triggers, met thresholds for bad behavior, and is associated with active campaigns.
   * **Spoof**: Traffic associated with phishing campaigns that is either non-compliant with your email authentication policies (SPF, DKIM, DMARC) or has mismatching Envelope From and `Header From` values.
   * **Spam**: Traffic associated with non-malicious, commercial campaigns.
   * **Bulk**: Traffic associated with [Graymail](https://en.wikipedia.org/wiki/Graymail_%28email%29), that falls in between the definitions of `SPAM` and `SUSPICIOUS`. For example, a marketing email that intentionally obscures its unsubscribe link.
   * **Clean**: Traffic not associated with any phishing campaigns.

5. Select **Save**.

To reclassify messages in bulk, select **Select all messages** > **Action** > **Request reclassification**.

To release messages in bulk, select **Select all messages** > **Action** > **Release**.

## Upload EML files

Email security classifies certain emails as "Clean". If you disagree with the disposition, you can upload an EML file and reclassify the email.

On the **Investigation** page:

1. Go to the email marked as **Clean**.
2. Select the three dots > **Request reclassification**.
3. Upload the EML file.
4. Select a new disposition.
5. Select **Save**.

## View reclassifications

Once you have reclassified your messages, you can access those on **Reclassifications**.

To view reclassifications:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/).

2. Select **Email security** > **Reclassifications**.

3. Choose from the following submission types:

   * [**Team submissions**](https://developers.cloudflare.com/cloudflare-one/email-security/reclassifications/team-submissions/): View emails your security team submitted for reclassification
   * [**User submissions**](https://developers.cloudflare.com/cloudflare-one/email-security/reclassifications/user-submissions/): View emails your users submitted for reclassification
   * [**Invalid submissions**](https://developers.cloudflare.com/cloudflare-one/email-security/reclassifications/invalid-submissions/): View submissions that could not be processed
