---
title: Trusted domains · Cloudflare One docs
description: Email security allows you to exempt known partner and internal
  domains from typical detection scanning. Adding trusted domains helps to
  reduce false positives on malicious, suspicious, and spoof dispositions. Email
  security only checks the date when the domain is created.
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/trusted-domains/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/trusted-domains/index.md
---

Email security allows you to exempt known partner and internal domains from typical detection scanning. Adding trusted domains helps to reduce false positives on malicious, suspicious, and spoof [dispositions](https://developers.cloudflare.com/cloudflare-one/email-security/reference/dispositions-and-attributes/). Email security only checks the date when the domain is created.

## How trusted domains work

Trusted domains are not for the email message itself, but for entire domains.

By default, Email security automatically detects lookalike domains. Lookalike domains can be something like this: `thisisdomain.com` and `thisisadomain.com`. Both domains almost look identical.

If an email is received from a domain that looks like a configured domain, this will trigger a detection. Trusted domain is configured to ignore this detection.

In [Additional detections](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/additional-detections/), you can configure malicious domain and suspicious [domain age](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/additional-detections/#configure-domain-age).

Malicious domain age means that someone may create a domain today, similar to a target, and start sending emails with that domain. This is usually how many phish campaigns start. In this case, the domain is usually marked as Malicious. Malicious domain age is usually set to 7 days.

Suspicious domain age means that after 7 days (this number corresponds to the Malicious domain age), a domain may not be malicious, but it can still be suspicious. Email security will mark these domains as Suspicious. It is recommended to configure the **Suspicious domain age** between 30 and 45 days.

To view whether a domain is malicious or suspicious:

1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Investigation**.

2. Run a screen. For example, select **Run screen** for **Malicious emails**, then select **Run screen**.

3. Under **Your matching messages**, if any message displays **Domain Age** under **Threat types**, that means that the domain age is too low, and therefore the disposition assigned is Malicious. If the domain is legitimate, you can add it as a trusted domain:

   * Go to **Settings** > **Trusted Domains**.
   * Under **Domain Info**, add the domain, and select **New Domain**. This will mark the domain whose age is low as a trusted domain.

## Configure trusted domains

To configure a trusted domain:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/).

2. Select **Email security**.

3. Select **Settings**, go to **Detection settings** > **Trusted domains**.

4. On the **Detection settings** page, select **Add a domain**.

5. Select the **Input method**: Choose between **Manual input**, and **Upload trusted domain list**:

   * **Manual input**:

     * **Domain info**: Enter a valid domain name.

     * **Domain type**: Select one or both options:

       * **Proximity domain**: Domains with similar spelling to your existing domain.
       * **Recent domain**: Domains created recently.

     - **Notes**: Provide additional information about the trusted domain list.

   * **Upload trusted domain list**: You can upload a file no larger than 150 KB of multiple trusted domains. The file can only contain `Domain`, `Proximity`, `New` and `Notes` fields. The first row must be a header row. Refer to [CSV uploads](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/trusted-domains/#csv-uploads) for an example file.

6. Select **Save**.

### CSV uploads

You can upload a file no larger than 150 KB of multiple trusted domains. The file can only contain `Domain`, `Proximity`, `New` and `Notes` fields. The first row must be a header row.

An example file would look like this:

```txt
Domain, Proximity, New, Notes
mydomain.com, true, true, First Person
testdomain.com, false, true, New Hire
```

## Export trusted domains

To export all trusted domains:

1. On the **Detection settings** page, select **Domain**. Selecting **Domain** will select all trusted domains.
2. Select **Export to CSV**.

To export specific trusted domains:

1. On the **Detection settings** page, select the trusted domains you want to export.
2. Select **Export to CSV**.

## Edit trusted domains

To edit a trusted domain:

1. On the **Detection settings** page, select the trusted domains you want to edit.
2. Select the three dots > Edit.
3. Edit the trusted domain.
4. Select **Save**.

## Delete trusted domains

To delete trusted domains:

1. On the **Detection settings** page, select the trusted domain you want to delete.
2. Select the three dots > **Delete**.
3. On the pop up message, select **Delete**.

To delete multiple trusted domains at once:

1. On the **Detection settings** page, select the trusted domains you want to delete.
2. Select **Action**.
3. Select **Delete**.
