---
title: Application Access Report · Cloudflare One docs
description: The Application Access Report provides a high-level summary of
  Access usage across your organization. This dashboard helps administrators
  monitor authentication patterns, identity provider usage, and Access
  configuration metrics. If Access is not configured in your account, the
  dashboard appears empty.
lastUpdated: 2025-10-30T12:11:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/analytics/application-access/
  md: https://developers.cloudflare.com/cloudflare-one/insights/analytics/application-access/index.md
---

The Application Access Report provides a high-level summary of [Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) usage across your organization. This dashboard helps administrators monitor authentication patterns, identity provider usage, and Access configuration metrics. If Access is not configured in your account, the dashboard appears empty.

To view the Application Access Report dashboard:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Insights**.
2. Go to **Dashboards**.
3. Select **Application Access Report**.

The [Application Access Report](https://developers.cloudflare.com/cloudflare-one/insights/analytics/application-access/) dashboard offers a summary of overall Access activity, while [Access event analytics](https://developers.cloudflare.com/cloudflare-one/insights/analytics/access/) dashboard provides a view of login events. You can export the Application Access Report to a PDF to share with stakeholders.

## Prerequisites

To populate the Application Access Report dashboard, you must have:

* At least one [Access application](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/) configured in your account.
* Users authenticating to these applications through Cloudflare Access.

## Available insights

The Application Access Report dashboard includes the following panels and metrics:

* [Summary of Access activity](#summary-of-access-activity)
* [Access events](#access-events)
* [Access decisions by event count](#access-decisions-by-event-count)
* [Access applications by event count](#access-applications-by-event-count)
* [Access events by type](#access-events-by-type)
* [Top counts of event details](#top-counts-of-event-details)
* [Access admin metrics](#access-admin-metrics)

### Summary of Access activity

The Summary of Access activity section shows a time series of Access login events over a selected period and a summary of login events. You can filter a time period in the upper right corner of the dashboard.

### Access events

Shows a time series of Access login events over a selected period. Each bar represents the number of login events in the x-axis time interval. You can use this graph to review user authentication activity and detect unusual login spikes.

### Access decisions by event count

Displays the total number of Access decisions made, grouped by outcome (for example, **Granted** or **Denied**).

### Access applications by event count

Shows a breakdown of authentication events by application type (for example, **Self-hosted**, **SaaS**, **Private network**, **Infrastructure** or **MCP Portal**).\
Use this view to determine which application types users most frequently access.

### Access events by type

Categorizes authentication events by method, such as **SSO** or **Login** (direct credential-based authentication).\
This panel helps administrators understand how users are authenticating across applications and identity providers.

### Top counts of event details

Lists the most common Access event attributes, including:

* Application name — Displays the top accessed applications.
* Identity provider — Shows which identity providers (IdPs) were most used.
* Users — Lists top users by number of login events.
* Countries — Displays top countries where users logged in.
* IP addresses — Lists the top source IPs associated with login events.

These insights help administrators identify usage patterns and trends.

### Access admin metrics

Provides a summary of Access configurations made by admin in your organization, including:

* Applications configured — Total number of Access-protected applications, broken down by type (for example, Self-hosted, SaaS, RDP, SSH, Private network, and Dash SSO.)
* Policies configured — Total number of Access policies, grouped by policy type (for example, Allow, Block, Bypass, or Service Auth.)

This section helps administrators audit their Access setup and verify that expected resources and policies are in place.
