---
title: Cipher suites · Cloudflare One docs
description: Cloudflare Tunnel connections use the cipher suites supported by
  cloudflared, which relies on the Go TLS library for its TLS implementation.
  These cipher suites apply to both the TLS connection between Cloudflare's
  network and cloudflared, and the HTTPS connection between cloudflared and your
  origin. In both cases, cloudflared negotiates the most secure cipher suite
  supported by both sides.
lastUpdated: 2025-10-29T16:39:14.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/cipher-suites/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/cipher-suites/index.md
---

Cloudflare Tunnel connections use the cipher suites supported by `cloudflared`, which relies on the Go TLS library for its TLS implementation. These cipher suites apply to both the TLS connection between Cloudflare's network and `cloudflared`, and the HTTPS connection between `cloudflared` and your origin. In both cases, `cloudflared` negotiates the most secure cipher suite supported by both sides.

The following table lists the cipher suites supported by `cloudflared`:

| Protocol support | Cipher suites |
| - | - |
| TLS 1.3 only | `TLS_AES_128_GCM_SHA256` `TLS_AES_256_GCM_SHA384` `TLS_CHACHA20_POLY1305_SHA256` |
| TLS 1.2 only | `TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256` `TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384` `TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256` `TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384` `TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256` `TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256` |
| Up to and including TLS 1.2 | `TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA` `TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA` `TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA` `TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA` |
