---
title: WAN Tunnels site analytics · Cloudflare One docs
description: After adding your sites, the Network visibility section of the
  dashboard provides a summary of the connectivity status and traffic analytics
  for all your sites. This is a great place to start if you receive a WAN
  Tunnels alert, need to begin the troubleshooting process, or are performing
  routine monitoring. Refer to Set up a site for more information on how to set
  up a site.
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/analytics/site-analytics/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/analytics/site-analytics/index.md
---

After adding your sites, the Network visibility section of the dashboard provides a summary of the connectivity status and traffic analytics for all your sites. This is a great place to start if you receive a WAN Tunnels alert, need to begin the troubleshooting process, or are performing routine monitoring. Refer to [Set up a site](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/sites/) for more information on how to set up a site.

Network visibility has the following data types available:

Geographic map summary

* [Aggregate WAN Tunnels site health](#site-health)
* [WAN Tunnels availability status for sites](#no-status-available)
* [WAN Tunnels site geographic location](#no-location-set)

WAN Tunnels site data table

* Site Name
* Site Health
* Site Tunnel Names
* Site Tunnel Statuses
* Site Traffic Sent
* Site Traffic Received

WAN Tunnels site data

* Traffic Sent by Tunnel
* Traffic Received by Tunnel

To start using WAN Tunnels site analytics:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/).
2. Go to **Insights** > **Network visibility**.

You will have access to an overview map with all your active sites, and any alerts for sites that are unhealthy or have no status available to them.

Review the topics below to learn more about the options available to you.

### Network map and traffic overview

The network map section shows all the sites configured with WAN Tunnels. At a glance, you can check:

* How many active sites you have
* Location for sites in a map (if you set up their geographic location)
* Sites that are healthy or unhealthy
* Sites that have no status available
* Sites that have no location set

Just below the map, Traffic overview shows a more granular list of your sites and their status.

#### Site health

Sites can be healthy or unhealthy, and WAN Tunnels uses this information to route traffic. Refer to [Set thresholds for site health](#set-thresholds-for-site-health) to learn more about this topic.

#### No status available

The status of a site refers to its health. If your sites show a **No status available** message, this means you did not configure your alert settings when creating your site. Refer to [Configure Magic Tunnel health alerts](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/configure-magic-tunnel-health-alerts/) to learn how to create an alert for your site.

#### No location set

The dashboard shows you the number of sites with no location set, meaning sites for which you did not set up a geographic location. To add a location to a site, find the site you want to add location to, and select **no location set** to edit its location settings. Refer to [Set geographic coordinates](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/sites/#set-geographic-coordinates) for more information.

### Traffic overview

Traffic overview aggregates all WAN Tunnels sites configured in your account. Here, you can check at-a-glance information about each site like:

* Site status
* Traffic sent and received

Select one of your sites to have access to a more detailed view of its traffic, including traffic by tunnel.

### Set thresholds for site health

When you set up an alert for your site, you will be notified when there is an issue with one or more on-ramps. These alerts are sent when the percentage of successful health checks for a WAN Tunnels on-ramp drops below the selected service-level objective (SLO). Setting health alerts will also show unhealthy tunnels in the Network map and in the Traffic overview sections.

To set up health alerts:

1. Configure [Magic Tunnel health alerts](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/configure-magic-tunnel-health-alerts/) across all of the Magic Tunnels associated with each WAN Tunnels site.
2. After configuring Magic Tunnel health alerts, any WAN Tunnels site with a Magic Tunnel (on-ramp) that is outside of its SLO threshold will be labeled unhealthy in Network map and Traffic overview.
