---
title: Troubleshooting · Cloudflare One docs
description: "Cloudflare customers can inspect metrics for a specific Appliance
  in the Cloudflare dashboard. These metrics help you troubleshoot potential
  issues with your device. The information spans categories such as:"
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/troubleshooting/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/troubleshooting/index.md
---

## Device metrics

Cloudflare customers can inspect metrics for a specific Appliance in the Cloudflare dashboard. These metrics help you troubleshoot potential issues with your device. The information spans categories such as:

* Performance analytics
* Port analytics
* Event logs
* DHCP leasing information

To find the information above and start troubleshooting your Appliance:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/), and go to **Networks** > **Connectors**.
2. Go to **Appliances** > **Profiles** > **View analytics**.

### Performance analytics

In Performance analytics you can review your Appliance's performance over time including:

* Kernel boot time (how long it has been running and if it is activated or not)
* Last device snapshot (this also shows the frequency with which your device captures the snapshots that are used in several troubleshooting procedures)
* CPU temperature
* CPU load over time
* Used RAM over time

To access performance analytics:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/), and go to **Networks** > **Connectors**.
2. Go to **Appliances** > **Profiles** > **View analytics**.

1) Select **Performance analytics**.

### Port analytics

Port analytics gives you access to information related to the packets sent and received through the ports in your Appliance. You can adjust the time range for the information displayed in the dashboard regarding to:

* Rate for packets sent and received
* Rate for data sent and received

The dashboard provides this information for all active ports in your Appliance. To access port analytics:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/), and go to **Networks** > **Connectors**.
2. Go to **Appliances** > **Profiles** > **View analytics**.

1) Select **Port analytics**.

### Event logs

Use Event logs to identify general patterns and changes over time. This is useful to find correlations with other data and gather deeper insights into your Appliance. The following event logs are available:

* `Init`: Initialized `mcon-agent` process. This process manages Connector.
* `Leave`: Stopped `mcon-agent` process.
* `StartAttestation`: Started attestation to verify the integrity of Connector before allowing the device to connect to your account.
* `FinishAttestationSuccess`: Finished attestation successfully.
* `FinishAttestationFailure`: Failed attestation.
* `StartRotateCryptKey`: Started cryptography key rotation.
* `FinishRotateCryptKeySuccess`: Finished cryptography key rotation.
* `FinishRotateCryptKeyFailure`: Failed cryptography key rotation.
* `StartRotatePki`: Started public key infrastructure (PKI) rotation.
* `FinishRotatePkiSuccess`: Finished PKI rotation.
* `FinishRotatePkiFailure`: Failed PKI rotation.
* `StartUpgrade`: Began Connector's operating system upgrade.
* `FinishUpgradeSuccess`: Finished operating system upgrade.
* `FinishUpgradeFailure`: Failed operating system upgrade.
* `Reconcile`: Cloudflare is comparing the system's current state against its desired state.
* `ConfigureCloudflaredTunnel`: Configured Cloudflare Tunnel to debug device.

To access event logs:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/), and go to **Networks** > **Connectors**.
2. Go to **Appliances** > **Profiles** > **View analytics**.

1) Select **Events**.
2) You can filter results by specific events, and by time.

### DHCP leasing

Refer to the DHCP leasing section to identify DHCP assigned leases and their expiration dates. To access DHCP leasing:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/), and go to **Networks** > **Connectors**.
2. Go to **Appliances** > **Profiles** > **View analytics**.

1) Select **DHCP leasing**.

## Troubleshooting tips

If you are experiencing difficulties with your Appliance, refer to the following tips to troubleshoot what might be happening.

## I have set up a site, but my Appliance is not working

Make sure that you have [activated your Appliance](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/configure-hardware-connector/#activate-appliance). Cloudflare ships the Appliance deactivated, and the it will only establish a connection to the Cloudflare network when it is activated.

## I have tried to activate Appliance, but it is still not working

Check if your Appliance is connected to the Internet via a port that can serve DHCP. This is required the first time a Appliance boots up so that it can reach the Cloudflare global network and download the required configurations that you set up in the Site configuration step. Refer to [Activate Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/configure-hardware-connector/#activate-appliance) for more details.

If you have a firewall deployed upstream of the Appliance, [check your firewall settings](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/configure-hardware-connector/#firewall-settings-required). You might need to configure your firewall to allow traffic in specific ports for the Appliance to work properly.

## I can access Appliance's health checks, but there is no traffic

If you have a firewall deployed upstream of the Appliance, make sure you review your [firewall settings](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/configure-hardware-connector/#firewall-settings-required). You might need to configure your firewall to allow traffic in specific ports for the Appliance to work properly.

## Devices I have behind Appliance cannot connect to the Internet

If you have other routing appliances behind Appliance, make sure you create policy-based routing policies to send traffic from your devices through Appliance, instead of these other routing devices.

## How do I know if my device is contacting Cloudflare?

Appliance sends a heartbeat periodically to Cloudflare. You can [access the dashboard](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/maintenance/heartbeat/), and check for the heartbeat status of your Connector device.

## What do I do in the event of hardware issues with Appliance?

Cloudflare is the single point of contact for any issues related to Appliance, including issues with hardware. When required, Cloudflare Support will work with our partner, TD Synnex, to resolve any issues with the physical device.
