---
title: Check tunnel health in the dashboard · Cloudflare One docs
description: The Cloudflare dashboard monitors the health of all anycast tunnels
  on your account that route traffic from Cloudflare to your origin network.
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/check-tunnel-health-dashboard/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/check-tunnel-health-dashboard/index.md
---

The Cloudflare dashboard monitors the health of all anycast tunnels on your account that route traffic from Cloudflare to your origin network.

The dashboard shows the view of tunnel health as measured from each Cloudflare location where your traffic is likely to land. If the tunnels are healthy on your side, you will see the majority of servers reporting an **up** status. It is normal for a subset of these locations to show tunnel status as degraded or unhealthy, since the Internet is not homogeneous and intermediary path issues between Cloudflare and your network can cause interruptions for specific paths.

Note

To access more than one hour of tunnel health data, you should use the [GraphQL API](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/analytics/query-tunnel-health/).

Not all data centers will be relevant to you at all times. You can refer to the **Average ingress traffic (last hour)** column to understand if a given data center is receiving traffic for your network, and if its health status is relevant to you.

To check for anycast tunnel health:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/) and go to **Insights**.

2. Go to **Network visibility** > **WAN connector health**.

3. In the next screen you can access a list of your tunnels and their current health status. You can also check the amount of health checks passed in the last hour as well as traffic volume for each tunnel.

4. Find the tunnel you wish to inspect, select the three dots in front of the tunnel and select:

   * **Create alert**: This will send you to the [notifications wizard](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/configure-magic-tunnel-health-alerts/) so you can create specific alerts for that tunnel, to be warned when specific conditions are met.
   * **Network Analytics**: This will send you to the Analytics section of the dash, prefiltered with the tunnel you want to inspect.

5. Alternatively, from the list of tunnels, select the tunnel you want to inspect to access details about it.

## Check tunnel health for a specific tunnel

Beyond having a wide view into all connections, you can drill down into a specific tunnel to check its health status and other information. Refer to the blue note above to learn how to access the new dashboard experience, and:

1. Go to **Insights > Network visibility > WAN connector health**.
2. Find and select the tunnel you wish to inspect.

The next screen shows you detailed information about the tunnel, including:

* Status information

  * Up: More than 80% of health checks are passing.
  * Degraded: More than 40% of health checks are passing.
  * Down: Less than 40% of health checks are passing.

* Health checks passed in the last hour

* Traffic volume in the last hour

If you select the three dots in front of the tunnel you want to inspect, you have access to the following tools:

* Packet captures: Collect [packet level data for you traffic](https://developers.cloudflare.com/magic-firewall/packet-captures/)
* Network Analytics: Leverage real-time visibility into [network analytics](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/analytics/network-analytics/).

Note

WAN Tunnels customers with [Customer Metadata Boundary](https://developers.cloudflare.com/data-localization/metadata-boundary/) enabled for the European Union are able to access GRE, IPsec, and CNI health check and traffic volume data in the Cloudflare dashboard and via API. This ensures that any WAN Tunnels customers that need to be GDPR compliant are able to access all WAN Tunnels features.

## Appliances

Appliances also includes a heartbeat function, an additional way of communicating its health status which does not depend on successfully setting up any tunnels. The heartbeat function communicates periodically with Cloudflare via HTTPS and lets Cloudflare know that the Appliances in question is connected to the Internet and reachable.

Refer to [Heartbeat](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/maintenance/heartbeat/) to learn more.
