---
title: Custom IKE ID for IPsec · Cloudflare One docs
description: WAN Tunnels customers can configure a custom IKE ID for their IPsec
  tunnels. Customers that are using WAN Tunnels and a VeloCloud SD-WAN device
  together should utilize this option to create a high availability
  configuration.
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/custom-ike-id-ipsec/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/common-settings/custom-ike-id-ipsec/index.md
---

WAN Tunnels customers can configure a custom IKE ID for their IPsec tunnels. Customers that are using WAN Tunnels and a VeloCloud SD-WAN device together should utilize this option to create a high availability configuration.

Note

This feature is only available via API. There are no configuration options for a custom IKE ID for an IPsec tunnel in the Cloudflare dashboard.

VeloCloud has a high availability mechanism that allows customers to specify one set of IKE parameters (like IKE ID) and multiple remote IPs. Customers create an IKE ID, and then assign the same custom IKE ID to their primary IPsec tunnel and their backup IPsec tunnel. FQDN is the only supported type for custom IKE IDs.

WAN Tunnels customers can set a custom IKE ID for an IPsec tunnel using the following API call. Customers will need to fill in the appropriate values for `<account_id>`, `<tunnel_id>`, and the FQDN wildcard before running the API call.

```bash
curl "https://api.cloudflare.com/client/v4/accounts/ACCOUNT_ID/ipsec_tunnels/TUNNEL_ID" \
  --request PATCH \
  --json '{
    "custom_remote_identities": {
        "fqdn_id": "<your_custom_label>.<account_id>.custom.ipsec.cloudflare.com"
    }
  }'
```
