---
title: Get started · Cloudflare One docs
description: WAN Tunnels allows you to achieve any-to-any connectivity across
  branch and retail sites and data centers, with Cloudflare connectivity cloud.
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/get-started/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/get-started/index.md
---

WAN Tunnels allows you to achieve any-to-any connectivity across branch and retail sites and data centers, with Cloudflare connectivity cloud.

## Before you begin

WAN Tunnels is an Enterprise-only product. [Contact Cloudflare](https://www.cloudflare.com/magic-wan/) to acquire WAN Tunnels. If you plan on using Appliances to automatically onboard your locations to Cloudflare, you will need to purchase WAN Tunnels first.

## Set up method

WAN Tunnels supports an automatic setup and a manual setup. The automatic setup through Appliances is the preferred method.

### Automatic set up

Setting up WAN Tunnels automatically is done through Appliances, and is the preferred method. You can choose between the hardware version and the virtual version of Appliances. The virtual version can be installed on your own machines.

If you plan on using Appliances, you can skip the prerequisites below, and refer to [Configure with Appliances](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/) for more information on how to continue.

### Manual set up

Setting up WAN Tunnels manually is done through a combination of third-party devices in your premises and the Cloudflare dashboard. To be successful, you need to:

1. Read the [Prerequisites](#prerequisites) below.
2. Follow the steps in [Manual configuration](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-tunnel-endpoints/).

## Prerequisites

Note

The list of prerequisites below is only for customers planning to connect manually to Cloudflare with a third-party device. If you plan on using Appliances, skip this section and refer to [Configure with Appliances](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/appliances/).

### Use compatible tunnel endpoint routers

WAN Tunnels relies on [GRE](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/reference/gre-ipsec-tunnels/) and [IPsec tunnels](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/reference/gre-ipsec-tunnels/#ipsec-tunnels) to transmit [packets](https://www.cloudflare.com/learning/network-layer/what-is-a-packet/) from Cloudflare's global network to your origin network. To ensure compatibility with WAN Tunnels, the routers at your tunnel endpoints must:

* Allow configuration of at least one tunnel per Internet service provider (ISP).
* Support maximum segment size (MSS) clamping.
* Support the configuration parameters for IPsec mentioned in [IPsec tunnels](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/reference/gre-ipsec-tunnels/#supported-configuration-parameters).

### Set maximum segment size

Before enabling WAN Tunnels, you must make sure that you set up the maximum segment size on your network. Cloudflare WAN Tunnels uses tunnels to deliver [packets](https://www.cloudflare.com/learning/network-layer/what-is-a-packet/) from our global network to your data centers. Cloudflare encapsulates these packets adding new headers. You must account for the space consumed by these headers when configuring the maximum transmission unit (MTU) and maximum segment size (MSS) values for your network.

#### MSS clamping recommendations

##### GRE tunnels as off-ramp

The MSS value depends on how your network is set up.

* **On your Edge router**: Apply the clamp to the GRE tunnel internal interface (meaning where the egress traffic will traverse). The MSS clamp should be 1,436 bytes. This may be done automatically once the tunnel is configured, but it depends on your devices.

##### IPsec tunnels

For IPsec tunnels, the value you need to specify depends on how your network is set up. The MSS clamping value will be lower than for GRE tunnels, however, since the physical interface will see IPsec-encrypted packets, not TCP packets, and MSS clamping will not apply to those.

* **On your Edge router**: Apply this on your IPsec tunnel internal interface (meaning where the egress traffic will traverse). This may be done automatically once the tunnel is configured but it depends on your devices. TCP MSS clamp should be 1,360 bytes maximum.

Important

Refer to your device documentation to check if it sets IPsec MSS clamping automatically. If that is not the case and you are using IPsec inside GRE, you have to set MSS clamp manually.

Refer to [Maximum transmission unit and maximum segment size](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/reference/mtu-mss/) for more details.

### Follow router vendor guidelines

Instructions to adjust MSS by applying MSS clamps vary depending on the vendor of your router.

The following table lists several commonly used router vendors with links to MSS clamping instructions:

| Router device | URL |
| - | - |
| Cisco | [TCP IP Adjust MSS](https://www.cisco.com/en/US/docs/ios-xml/ios/ipapp/command/ip_tcp_adjust-mss_through_ip_wccp_web-cache_accelerated.html#GUID-68044D35-A53E-42C1-A7AB-9236333DA8C4) |
| Juniper | [TCP MSS - Edit System](https://www.juniper.net/documentation/en_US/junos/topics/reference/configuration-statement/tcp-mss-edit-system.html) |
