---
title: Set up Browser Isolation · Cloudflare One docs
description: Browser Isolation is enabled through Secure Web Gateway HTTP
  policies. By default, no traffic is isolated until you have added an Isolate
  policy to your HTTP policies.
lastUpdated: 2025-10-28T13:40:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/
  md: https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/index.md
---

Browser Isolation is enabled through [Secure Web Gateway HTTP policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/). By default, no traffic is isolated until you have added an Isolate policy to your HTTP policies.

## 1. Connect devices to Cloudflare

Setup instructions vary depending on how you want to connect your devices to Cloudflare. Refer to the links below to view the setup guide for each deployment option.

| Connection | Mode | Description |
| - | - | - |
| [Gateway with WARP](https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/http/) | In-line | Apply identity-based HTTP policies to traffic proxied through the WARP client. |
| [Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/isolate-application/) | In-line | Apply identity-based HTTP policies to Access applications that are rendered in a remote browser. |
| [Gateway proxy endpoint](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/non-identity/) | In-line | Apply non-identity HTTP policies to traffic forwarded to a proxy endpoint. |
| [Magic WAN](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/non-identity/) | In-line | Apply non-identity HTTP policies to traffic connected through a GRE or IPsec tunnel. |
| [Clientless remote browser](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/) | Prefixed URL | Render web pages in a remote browser when users go to `https://<your-team-name>.cloudflareaccess.com/browser/<URL>`. |

## 2. Build an Isolation policy

To configure Browser Isolation policies:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Traffic policies** > **Firewall policies** > **HTTP**.
2. Select **Add a policy** and enter a name for the policy.
3. Use the HTTP policy [selectors](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#selectors) and [operators](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#comparison-operators) to specify the websites or content you want to isolate.
4. For **Action**, choose either [*Isolate*](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/isolation-policies/#isolate) or [*Do not Isolate*](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/isolation-policies/#do-not-isolate).
5. (Optional) Configure [settings](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/isolation-policies/#policy-settings) for an Isolate policy.
6. Select **Create policy**.

Next, [verify that your policy is working](#3-check-if-a-web-page-is-isolated).

## 3. Check if a web page is isolated

Users can see if a webpage is isolated by using one of the following methods:

* Select the padlock in the address bar and check for the presence of a Cloudflare Root CA.
* Right-click the web page and view the context menu options.

### Normal browsing

* A non-Cloudflare root certificate indicates that Cloudflare did not proxy this web page.

  ![Website does not present a Cloudflare root certificate](https://developers.cloudflare.com/_astro/non-cloudflare-root-ca.DUtGDw33_Z23xa2g.webp)

* The right-click context menu will have all of the normal options.

  ![Normal right-click menu in browser](https://developers.cloudflare.com/_astro/non-isolated-browser.B9h2hRe6_1BhOOR.webp)

### Isolated browsing

* A Cloudflare root certificate indicates traffic was proxied through Cloudflare Gateway.

  ![Website presents a Cloudflare root certificate](https://developers.cloudflare.com/_astro/cloudflare-gateway-root-ca.DLxxnVYn_Z2qAJ1j.webp)

* The right-click context menu will be simplified.

  ![Simplified right-click menu in browser](https://developers.cloudflare.com/_astro/isolated-browser.CBtYLGGn_2qt5Dl.webp)

#### Disconnect Browser Isolation

WARP users can temporarily disable remote browsing by [disconnecting the WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#lock-warp-switch). Once WARP is disconnected, a refresh will return the non-isolated page.
