---
title: User logs · Cloudflare One docs
description: User logs show a list of all users who have authenticated to
  Cloudflare One. For each user who has logged in, you can view their enrolled
  devices, login history, seat usage, and identity used for policy enforcement.
lastUpdated: 2025-10-30T12:11:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/users/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/users/index.md
---

User logs show a list of all users who have authenticated to Cloudflare One. For each user who has logged in, you can view their enrolled devices, login history, seat usage, and identity used for policy enforcement.

## View user logs

In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Teams & Resources** > **Users**.

This page lists all users who have registered the WARP client or authenticated to a Cloudflare Access application. You can select a user's name to view detailed logs, [revoke their session](https://developers.cloudflare.com/cloudflare-one/access-controls/access-settings/session-management/#revoke-user-sessions), or [remove their seat](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/seat-management/).

### Available logs

* **User Registry identity**: Select the user's name to view their last seen identity. This identity is used to evaluate Gateway policies and WARP [device profiles](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/device-profiles/). A refresh occurs when the user re-authenticates WARP, logs into an Access application, or has their IdP group membership updated via [SCIM provisioning](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/scim/). To track how the user's identity has changed over time, go to the **Audit logs** tab.
* **Session identities**: The user's active sessions, the identity used to authenticate each session, and when each session will [expire](https://developers.cloudflare.com/cloudflare-one/access-controls/access-settings/session-management/).
* **Devices**: Devices registered to the user via WARP.
* **Recent activities**: The user's five most recent Access login attempts. For more details, refer to your [authentication audit logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/audit-logs/#authentication-audit-logs).
