---
title: File sandboxing · Cloudflare One docs
description: In addition to anti-virus (AV) scanning, Gateway can quarantine
  previously unseen files downloaded by your users into a sandbox and scan them
  for malware.
lastUpdated: 2025-10-28T22:09:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/file-sandboxing/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/file-sandboxing/index.md
---

Note

Available as an add-on to Zero Trust Enterprise plans. For more information, contact your account team.

In addition to [anti-virus (AV) scanning](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/antivirus-scanning/), Gateway can quarantine previously unseen files downloaded by your users into a sandbox and scan them for malware.

If AV scanning does not detect malware in a file download, Gateway will quarantine the file in the [sandbox](#sandbox-environment). If the file has not been downloaded before, Gateway will monitor any actions taken by the file and compare them to known malware patterns. During this process, Gateway will display an interstitial page in the user's browser. If the sandbox does not detect malicious activity, Gateway will release the file from quarantine and download it to your user's device. If the sandbox detects malicious activity, Gateway will block the download. For any subsequent downloads of the file, Gateway will remember and apply its allow/block decision.

Gateway will log any file sandbox decisions in your [HTTP logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/gateway-logs/#http-logs).

```mermaid
flowchart TD
    A(["User starts file download"]) --> B["File sent to AV scanner"]
    B --> C["Malicious file detected?"]
    C -- Yes --> D["Download blocked"]
    C -- No --> G["File sent to sandbox"]
    G --> n1["First time file downloaded?"]
    K["Malicious activity detected?"] -- Yes --> N["Download blocked"]
    K -- No --> n3["Download allowed"]
    n2["Interstitial page displayed for user during scan"] --> n4["File activity monitored"]
    n1 -- Yes --> n2
    n4 --> K
    n1 -- No --> K

    B@{ shape: subproc}
    C@{ shape: hex}
    D@{ shape: terminal}
    n1@{ shape: hex}
    K@{ shape: hex}
    N@{ shape: terminal}
    n3@{ shape: terminal}
    n2@{ shape: display}
    n4@{ shape: rect}
    style D stroke:#D50000
    style N stroke:#D50000
    style n3 stroke:#00C853
```

## Get started

To begin quarantining downloaded files, turn on file sandboxing:

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Traffic policies** > **Traffic settings**.
2. Turn on **File sandboxing**.
3. (Optional) To block requests containing [non-scannable files](#non-scannable-files), select **Block requests for files that cannot be scanned**.

You can now create [Quarantine HTTP policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#quarantine) to determine what files to scan in the sandbox.

## Create test policy

To test if file sandboxing is working, you can create a Quarantine policy that matches the [Cloudflare Sandbox Test](https://sandbox.cloudflaredemos.com/):

1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Traffic policies** > **Firewall policies**, then select **HTTP**.

2. Select **Add a policy**.

3. Add the following expression:

   | Selector | Operator | Value | Action |
   | - | - | - | - |
   | Host | is | `sandbox.cloudflaredemos.com` | Quarantine |

4. In **Sandbox file types**, select *ZIP Archive (zip)*.

5. From a device [connected to your Zero Trust organization](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/), open a browser and go to the [Cloudflare Sandbox Test](https://sandbox.cloudflaredemos.com/).

6. Select **Download Test File**.

Gateway will quarantine and scan the file, display an interstitial status page in the browser, then release the file for download.

## Sandbox environment

Gateway executes quarantined files in a sandboxed Windows operating system environment. Using machine learning, the sandbox compares how files of a certain type behave compared to how these files should behave. The sandbox detects file actions down to the kernel level and compare these a real-time malware database. In addition, Gateway checks the sandbox's network activity for malicious behavior and data exfiltration.

## Compatibility

### Supported file types

File sandboxing supports scanning the following file types:

Supported sandboxing file types

* `.exe`
* `.pdf`
* `.doc`
* `.docm`
* `.docx`
* `.rtf`
* `.ppt`
* `.pptx`
* `.xls`
* `.xlsm`
* `.xlsx`
* `.zip`
* `.rar`

### Non-scannable files

Gateway cannot scan requests containing the following files:

* Files larger than 100 MB
* PGP encrypted files
