---
title: Protocol detection · Cloudflare One docs
description: Gateway supports the detection, logging, and filtering of network
  protocols using packet attributes.
lastUpdated: 2025-10-28T13:40:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/protocol-detection/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/protocol-detection/index.md
---

Gateway supports the detection, logging, and filtering of network protocols using packet attributes.

Protocol detection only applies to devices connected to Cloudflare One via the WARP client in [Gateway with WARP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#gateway-with-warp-default) mode.

## Turn on protocol detection

To turn on protocol detection:

1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Traffic policies** > **Traffic settings** > **Proxy and inspection settings**.
2. Turn on **Allow protocol detection**.

You can now use *Detected Protocol* as a selector in a [Network policy](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/#detected-protocol).

### Inspect on all ports Beta

By default, Gateway will only inspect HTTP traffic through port `80`. Additionally, if you [turn on TLS decryption](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#turn-on-tls-decryption), Gateway will inspect HTTPS traffic through port `443`.

To detect and inspect HTTP and HTTPS traffic on ports in addition to `80` and `443`, under **HTTP inspection ports**, choose *Inspect on all ports*.

Inspecting traffic on all ports works best if you allow all traffic by default. If your organization uses a Network policy to block all traffic by default, Gateway will allow all non-HTTPS TLS traffic, and you will not be able to filter this traffic. To use HTTP policies to filter all TLS traffic on all ports when using a default Block Network policy, [create a Network policy to explicitly allow HTTP and TLS traffic](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/common-policies/#filter-http-traffic-when-inspecting-on-all-ports).

## Supported protocols

Gateway supports detection and filtering of the following protocols:

| Protocol | Notes |
| - | - |
| HTTP | The policy builder includes separate values for HTTP/1.1 and HTTP/2. |
| SSH | |
| TLS | Gateway detects TLS versions 1.1 through 1.3 with the *TLS* value. |
| DCE/RPC | |
| MQTT | |
| TPKT | TPKT commonly initiates RDP sessions, so you can use it to identify and filter RDP traffic. |
| DNP3 | |

## Example network policy

You can create network policies that filter traffic based on protocol detections rather than common ports. For example, you can block all SSH traffic on your network without blocking port 22 or any other non-default ports:

| Selector | Operator | Value | Action |
| - | - | - | - |
| Detected Protocol | in | *SSH* | Block |
