---
title: Override expressions for Network-layer DDoS Attack Protection ·
  Cloudflare DDoS Protection docs
description: "Set an override expression for the Network-layer DDoS Attack
  Protection managed ruleset to define a specific scope for sensitivity level or
  action adjustments. For example, you can set different sensitivity levels for
  different destination IP addresses or ports: a medium sensitivity level for
  destination IP address A and a low sensitivity level for destination IP
  address B."
lastUpdated: 2025-06-30T19:31:22.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/network-overrides/override-expressions/
  md: https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/network-overrides/override-expressions/index.md
---

Set an override expression for the Network-layer DDoS Attack Protection managed ruleset to define a specific scope for [sensitivity level](https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/override-parameters/#sensitivity-level) or [action](https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/override-parameters/#action) adjustments. For example, you can set different sensitivity levels for different destination IP addresses or ports: a medium sensitivity level for destination IP address `A` and a low sensitivity level for destination IP address `B`.

## Available expression fields

You can use the following fields in override expressions:

* `ip.src`
* `ip.dst`
* `ip.proto.num`
* `ip.len`
* `ip.ttl`
* `tcp.srcport`
* `tcp.dstport`
* `tcp.flags`
* `tcp.flags.ack`
* `tcp.flags.fin`
* `tcp.flags.push`
* `tcp.flags.reset`
* `tcp.flags.syn`
* `tcp.flags.urg`
* `udp.srcport`
* `udp.dstport`

Refer to the [Fields reference](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/) in the Rules language documentation for more information.

## Important remarks

* Each expression is limited to 4,000 characters, which means you can enter approximately a maximum of 200 IP addresses in a single expression. However, you can enter IP addresses in CIDR format, which allows you to include a larger number of IP addresses. For example, you can use `192.0.0.0/24` to match IP addresses from `192.0.0.0` to `192.0.0.255`.
* Override expressions are not allowlists. They apply to the mitigation, not during detection. This means an override only takes effect if the attack fingerprint — as generated by the DDoS managed rules — includes the same fields specified in your expression.

For example, if you create an override with sensitivity set to `Essentially Off` for `ip.src eq 192.0.2.1`, it only applies if the fingerprint includes `ip.src`. However, because DDoS attacks are often distributed across many source IPs, the fingerprint may not include `ip.src` at all. In such cases, your override is not applied.

In a common scenario, an attack originating from thousands of IPs can target a single destination IP and port. The fingerprint would focus on the shared attributes, such as the destination IP, port, and additional packet fields that represent strong signals of the attack pattern. Even if your override matches a specific source IP, it will not apply if that field is not present in the fingerprint. As a result, the system will mitigate the attack using the default high sensitivity, and traffic from your specified IP could still be blocked. It is recommended to use more stable expressions such as protocol, destination IP, and destination port.
