---
title: Onboard a domain · Cloudflare Fundamentals docs
description: Learn how to connect the domain to Cloudflare, even if you
  purchased your domain name from another provider.
lastUpdated: 2025-10-09T15:47:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/manage-domains/add-site/
  md: https://developers.cloudflare.com/fundamentals/manage-domains/add-site/index.md
---

If you purchased your domain from a different provider, you can still connect the domain to Cloudflare. After you connect your domain to Cloudflare, Cloudflare will act as the [reverse proxy](https://developers.cloudflare.com/fundamentals/concepts/how-cloudflare-works/#cloudflare-as-a-reverse-proxy) and [DNS provider](https://developers.cloudflare.com/fundamentals/concepts/how-cloudflare-works/#cloudflare-as-a-dns-provider) for your site.

The information below applies to a [full DNS setup](https://developers.cloudflare.com/dns/zone-setups/full-setup) which is the most common configuration.

Note

To use Cloudflare as a reverse proxy but maintain your DNS provider, refer to [partial setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/). To use one or more DNS providers, refer to or [DNS Zone transfers](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/).

## Prerequisites

[Disable DNSSEC](https://developers.cloudflare.com/dns/dnssec/#disable-dnssec) at the registrar where you purchased your domain name to avoid connectivity errors when you change your nameservers.

## 1. Onboard a domain in Cloudflare

1. Log in to the Cloudflare dashboard.

   [Go to **Account home**](https://dash.cloudflare.com/?to=/:account/home)

2. Select **Onboard a domain**.

3. Enter your website's apex domain (for example, `example.com`), choose how you would like to add your [DNS records](https://developers.cloudflare.com/dns/manage-dns-records/), and select **Continue**.

   Note

   If Cloudflare is unable to identify your domain as a registered domain, make sure you are using an existing [top-level domain](https://www.cloudflare.com/learning/dns/top-level-domain/) (`.com`, `.net`, `.biz`, or others).

   Cloudflare requires your apex domain to be one level below a valid TLD defined in the [Public Suffix List (PSL)](https://github.com/publicsuffix/list/blob/master/public_suffix_list.dat). Enterprise customers can onboard lower-level subdomains using [Subdomain setup](https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/).

4. Select a [plan](https://www.cloudflare.com/plans/#compare-features).

5. [Review your DNS records](https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/#review-dns-records) to ensure none are missing. Your DNS records must accurate for your domain to work properly.

   Cloudflare can [automatically scan for common records](https://developers.cloudflare.com/dns/zone-setups/reference/dns-quick-scan/) and add them to the [DNS zone](https://developers.cloudflare.com/dns/concepts/#zone) for you, or you can add records manually. These records show up under your domain on the [**DNS Records**](https://dash.cloudflare.com/?to=/:account/:zone/dns/records) page of the dashboard.



   1. Since the quick scan is not guaranteed to find all existing DNS records, you need to review your records, paying special attention to the following:

      * [Zone apex records (`example.com`)](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-zone-apex/)

        More about zone apex records

        Zone apex refers to the domain or subdomain that you are [adding to Cloudflare](https://developers.cloudflare.com/dns/concepts/#zone).

        Usually, the zone apex record makes your domain accessible by visitors. In this case, the necessary record type ([A, AAAA, or CNAME](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#ip-address-resolution)) and its content will depend on the provider that [hosts](https://developers.cloudflare.com/fundamentals/manage-domains/#host-your-domain) your website or application.

        If you are using Cloudflare Pages, refer to [Custom domains](https://developers.cloudflare.com/pages/configuration/custom-domains/).

        If you are using other providers, look for their guidance on how to connect domains managed on external DNS services. Then, make sure you have the records required by your hosting provider on your [DNS records table](https://developers.cloudflare.com/dns/manage-dns-records/#dns-records-table) at Cloudflare.

      * [Subdomain records (`www.example.com` or `blog.example.com`)](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-subdomain/)

        More about subdomain records

        Most subdomains serve a specific purpose within the overall context of your website. For example, `blog.example.com` might be your blog, `support.example.com` could be your customer help portal, and `store.example.com` would be your e-commerce site.

        Even if you do not require specific subdomains, you might want to set up at least a subdomain record on `www`. It will usually point to the same content as what you have on the apex domain (`example.com`) or use a [redirect](https://developers.cloudflare.com/fundamentals/manage-domains/manage-subdomains/#redirect-a-subdomain-to-the-apex-domain). Having a subdomain DNS record on `www` helps guarantee that a visitor who types `www.` in front of your domain address can still find your website or application.

      * [Email records](https://developers.cloudflare.com/dns/manage-dns-records/how-to/email-records/)

        More about email records

        Depending on your business needs, you can configure DNS records so that you can use your domain to receive emails, receive and send emails from your domain, or prevent others from sending emails on your behalf (spoofing).

        Below are some examples of what those DNS records might look like. The exact values for your DNS mail records depend on your email provider. If you have issues, review the [Troubleshooting](https://developers.cloudflare.com/dns/troubleshooting/email-issues/) and contact your email service provider to confirm your DNS records are correct.

        | Type | Name | Content | Proxy status | TTL |
        | - | - | - | - | - |
        | A | `mail` | `192.0.2.1` | DNS Only | Auto |
        | MX | `example.com` | `5 john.mx.example-server.test` | DNS Only | Auto |
        | TXT | `_dmarc` | `"v=DMARC1; p=reject; sp=...` | DNS Only | Auto |
        | TXT | `*._domainkey` | `"v=DKIM1; k=rsa; p=..."` | DNS Only | Auto |
        | TXT | `example.com` | `"v=spf1 ip4:..."` | DNS Only | Auto |

      Note

      If you activate your domain on Cloudflare *without* setting up the correct DNS records for your domain and subdomain, your visitors may experience [DNS\_PROBE\_FINISHED\_NXDOMAIN](https://developers.cloudflare.com/dns/troubleshooting/dns-probe-finished-nxdomain/) errors.

   2. If you find any missing records, [manually add](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records/) those records.

   3. Depending on your site setup, you may want to adjust the [proxy status](https://developers.cloudflare.com/dns/proxy-status/) for certain `A`, `AAAA`, or `CNAME` records.

   4. Select **Continue**.

## 2. Update nameservers

Once you have added a domain (also known as a *zone*) to Cloudflare, that domain will receive two assigned authoritative nameservers.



Before your domain can begin using Cloudflare for DNS resolution, you need to [add these nameservers](https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/#update-your-nameservers) at your registrar. DNSSEC should still be **disabled** at this point.

If you cannot [change your domain nameservers](https://developers.cloudflare.com/dns/zone-setups/full-setup/), you can still use Cloudflare on your website by activating Cloudflare through a [certified hosting partner](https://www.cloudflare.com/hosting-partners) using a [partial (CNAME) setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/).

Warning

If your domain is particularly sensitive to downtime, review our suggestions to [minimize downtime](https://developers.cloudflare.com/fundamentals/performance/minimize-downtime/).

## 3. Complete SSL/TLS setup

To prevent insecure connections and visitor browser errors, [enable SSL/TLS protection](https://developers.cloudflare.com/ssl/get-started/). Many Cloudflare services will automatically protect and speed up your web traffic after your nameservers are updated.

If you encounter unexpected results when changing your nameservers, refer to the [DNS Full Setup troubleshooting](https://developers.cloudflare.com/dns/zone-setups/full-setup/troubleshooting/).
