---
title: Troubleshoot private networks · Cloudflare Learning Paths
description: Follow this troubleshooting procedure when end users running
  Cloudflare WARP have issues connecting to a private network behind Cloudflare
  Tunnel.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/replace-vpn/troubleshooting/troubleshoot-private-networks/
  md: https://developers.cloudflare.com/learning-paths/replace-vpn/troubleshooting/troubleshoot-private-networks/index.md
---

Follow this troubleshooting procedure when end users running Cloudflare WARP have issues connecting to a private network behind Cloudflare Tunnel.

## 1. Is the WARP client connected to a Cloudflare data center?

The WARP client GUI should display `Connected` and `Your Internet is protected`.

![WARP client GUI when connected to Cloudflare](https://developers.cloudflare.com/_astro/warp-connected.OHWKwu9t_Z1aOY3o.webp)

If WARP is stuck in the `Disconnected` state or frequently changes between `Connected` and `Disconnected`, refer to [Unable to connect WARP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/common-issues/#unable-to-connect-warp).

## 2. Is the WARP client connecting to your private DNS server?

This step is only needed if users access your application via a private hostname (for example, `wiki.internal.local`).

* If you are using [custom resolver policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/resolver-policies/) to handle private DNS, go to your Gateway DNS logs (**Insights** > **Logs** > **DNS query logs**) and search for DNS queries to the hostname.

* If you are using [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/) to handle private DNS, go to your Gateway Network logs (**Insights** > **Logs** > **Network logs**) and search for port `53` traffic to your DNS server IP.

If there are no relevant Gateway logs, it means that WARP was unable to forward the query to your private DNS server. Check your resolver policies or Local Domain Fallback configuration and refer to [How WARP handles DNS requests](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/#how-the-warp-client-handles-dns-requests).

## 3. Is network traffic to the application going through WARP?

Next, check if your Gateway Network logs (**Insights** > **Logs** > **Network logs**) show any traffic to the destination IP.

If WARP is connected but there are no network logs, it means that your private network IPs are not routing through WARP. You can confirm this by [searching the routing table](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#routing-table) on the device for the IP address of your application. Traffic to your application should route through the Cloudflare WARP interface. If another interface is used, [check your Split Tunnel configuration](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/#3-route-private-network-ips-through-warp).

## 4. Is the user blocked by a Gateway policy?

To check if a Gateway block event occurred:

1. Go to **Insights** > **Logs** and select the **DNS query logs**, **Network logs**, or **HTTP request logs**.

2. Apply the following filters:

   * **Email**: User's email address
   * **Event**: *Blocked*
   * **Date Time Range**: Time period when the user accessed the application

## 5. Is the user matching the correct Gateway policy?

Determine whether the user is matching any policy, or if they are matching a policy that has a higher priority than the expected policy.

1. To determine the actual policy that was applied:

   1. Go to **Insights** > **Logs** and select the **DNS query logs**, **Network logs**, or **HTTP request logs**.

   2. Apply the following filters:

      * **Email**: User's email address
      * **Date Time Range**: Time period when the user accessed the application

   3. In the search box, filter by the destination IP or FQDN.

   4. In the results, select a log and note its **Policy Name** value.

2. Go to **Traffic policies** > **Firewall policies** and compare the [order of enforcement](https://developers.cloudflare.com/cloudflare-one/traffic-policies/order-of-enforcement/) of the matched policy versus the expected policy.

3. Compare the Gateway log values with the expected policy criteria.

   * If the mismatched value is related to identity, [check the user registry](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/users/) and verify the values that are passed to Gateway from your IdP. Cloudflare updates the registry when the user enrolls in the WARP client. If the user's identity is outdated, ask the user to re-authenticate WARP (**Preferences** > **Account** > **Re-Authenticate Session**).

   * If the mismatched value is related to device posture, [view posture check results](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/#2-verify-device-posture-checks) for the user's device. Verify that the device passes the posture checks configured in the policy.

## 6. Are the correct Gateway proxy settings enabled?

Under **Traffic policies** > **Traffic settings**, ensure that **Allow Secure Web Gateway to proxy traffic** is enabled for TCP, UDP, and ICMP traffic. UDP is required for proxying DNS traffic and other UDP packets, while ICMP is required for `ping` and other administrative functions.

## 7. Is the user's traffic reaching the tunnel?

[Review your tunnel log stream](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/monitor-tunnels/logs/#view-logs-on-your-local-machine). If you do not see any requests to your application, ensure that you have added the appropriate static routes to your Cloudflare Tunnel.

## 8. Is the tunnel forwarding requests to your application?

Verify that you can connect to the application directly from the `cloudflared` host machine:

* macOS and Linux

  Open Terminal and run the following command:

  ```sh
  telnet test.example.com 443
  ```

  If `telnet` fails to open the connection, check your infrastructure for firewalls, load balancers, or other network devices that may be interfering with the connection between `cloudflared` and the application server.

* Windows

  Open PowerShell and run the following command:

  ```powershell
  PS C:\Users\JohnDoe> Test-NetConnection test.example.com -port 443
  ```

  If the output shows `TcpTestSucceeded : False`, check your infrastructure for firewalls, load balancers, or other network devices that may be interfering with the connection between `cloudflared` and the application server.

You can also use a packet capture tool such as `tcpdump` or Wireshark to trace whether traffic from the user device successfully reaches `cloudflared` and routes to your application. Traffic to your application will carry the source IP of the `cloudflared` host.

## 9. How is your application handling requests?

1. Check if the application server has a local firewall in place that is blocking requests from the `cloudflared` host machine.

2. Check if the application server needs to initiate any connection towards the user's device. If so, this is a limitation of `cloudflared` and you should instead [deploy WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/) to enable bidirectional traffic.

## 10. Is TLS inspection affecting the connection to your application?

If there is a problem with [TLS inspection](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/), the user will get an `Insecure Upstream` error when they access the application in a browser. They will probably not get an error if they access the application outside of a browser.

Customers who have [Logpush](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/) enabled can check the [Gateway HTTP dataset](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/gateway_http/) for any hostnames which have an elevated rate of `526` HTTP status codes.

To troubleshoot TLS inspection:

1. Create a temporary Gateway HTTP policy that disables TLS inspection for all traffic to the application. For example:

   | Selector | Operator | Value | Action |
   | - | - | - | - |
   | Destination IP | in | `10.2.3.4/32` | Do Not Inspect |

2. If the `Do Not Inspect` policy enables the user to connect, verify that the TLS certificate used by your application is trusted by a public CA and not self-signed. Cloudflare Gateway is unable to negotiate TLS with applications that use self-signed certificates. For more information, refer to [TLS inspection limitations](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#inspection-limitations).

   To work around the issue:

   * **Option 1:** Create a permanent [`Do Not Inspect` HTTP policy](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#do-not-inspect) for this application.
   * **Option 2:** Customers who use their [own certificate infrastructure](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/custom-certificate/) for inspection can opt to create an [Allow *Pass Through* policy](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#untrusted-certificates) which enables our proxy to accept the TLS negotiation from your application. This will allow requests to flow correctly without the need for a `Do Not Inspect` policy.
   * **Option 3:** If your application uses `HTTPS` or other common protocols, you can add a [published application](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/routing-to-tunnel/) to your Cloudflare Tunnel and set [noTLSVerify](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/cloudflared-parameters/origin-parameters/#notlsverify) to `true`. This will allow `cloudflared` to trust your self-signed certificate.
