---
title: Logs · Cloudflare Logs docs
description: Logpush now supports integration with Microsoft Sentinel.The new
  Azure Sentinel Connector built on Microsoft’s Codeless Connector Framework
  (CCF), is now avaialble. This solution replaces the previous Azure
  Functions-based connector, offering significant improvements in security, data
  control, and ease of use for customers. Logpush customers can send logs to
  Azure Blob Storage and configure this new Sentinel Connector to ingest those
  logs directly into Microsoft Sentinel.
lastUpdated: 2025-10-02T14:04:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/logs/changelog/logs/
  md: https://developers.cloudflare.com/logs/changelog/logs/index.md
---

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/logs.xml)

## 2025-10-27

**Azure Sentinel Connector**

Logpush now supports integration with [Microsoft Sentinel](https://www.microsoft.com/en-us/security/business/siem-and-xdr/microsoft-sentinel).The new Azure Sentinel Connector built on Microsoft’s Codeless Connector Framework (CCF), is now avaialble. This solution replaces the previous Azure Functions-based connector, offering significant improvements in security, data control, and ease of use for customers. Logpush customers can send logs to Azure Blob Storage and configure this new Sentinel Connector to ingest those logs directly into Microsoft Sentinel.

This upgrade significantly streamlines log ingestion, improves security, and provides greater control:

* Simplified Implementation: Easier for engineering teams to set up and maintain.
* Cost Control: New support for Data Collection Rules (DCRs) allows you to filter and transform logs at ingestion time, offering potential cost savings.
* Enhanced Security: CCF provides a higher level of security compared to the older Azure Functions connector.
* ata Lake Integration: Includes native integration with Data Lake.

Find the new solution [here](https://marketplace.microsoft.com/en-us/product/azure-application/cloudflare.azure-sentinel-solution-cloudflare-ccf?tab=Overview) and refer to the [Cloudflare's developer documention](https://developers.cloudflare.com/analytics/analytics-integrations/sentinel/#supported-logs:~:text=WorkBook%20fields,-Analytic%20rules)for more information on the connector, including setup steps, supported logs and Microsfot's resources.

## 2025-08-22

**Dedicated Egress IP for Logpush**

Cloudflare Logpush can now deliver logs from using fixed, dedicated egress IPs. By routing Logpush traffic through a Cloudflare zone enabled with [Aegis IP](https://developers.cloudflare.com/aegis/), your log destination only needs to allow Aegis IPs making setup more secure.

Highlights:

* Fixed egress IPs ensure your destination only accepts traffic from known addresses.
* Works with any supported Logpush destination.
* Recommended to use a dedicated zone as a proxy for easier management.

To get started, work with your Cloudflare account team to provision Aegis IPs, then configure your Logpush job to deliver logs through the proxy zone. For full setup instructions, refer to the [Logpush documentation](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/egress-ip/).

## 2025-08-13

**IBM Cloud Logs as Logpush destination**

Cloudflare Logpush now supports IBM Cloud Logs as a native destination.

Logs from Cloudflare can be sent to [IBM Cloud Logs](https://www.ibm.com/products/cloud-logs) via [Logpush](https://developers.cloudflare.com/logs/logpush/). The setup can be done through the Logpush UI in the Cloudflare Dashboard or by using the [Logpush API](https://developers.cloudflare.com/api/resources/logpush/subresources/jobs/). The integration requires IBM Cloud Logs HTTP Source Address and an IBM API Key. The feature also allows for filtering events and selecting specific log fields.

For more information, refer to [Destination Configuration](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/ibm-cloud-logs/) documentation.

## 2025-04-18

**Custom fields raw and transformed values support**

Custom Fields now support logging both **raw and transformed values** for request and response headers in the HTTP requests dataset.

These fields are configured per zone and apply to all Logpush jobs in that zone that include request headers, response headers. Each header can be logged in only one format—either raw or transformed—not both.

By default:

* Request headers are logged as raw values
* Response headers are logged as transformed values

These defaults can be overidden to suit your logging needs.

Note

Transformed and raw values for request and response headers are available **only via the API** and cannot be set through the UI.

For more information refer to [Custom fields](https://developers.cloudflare.com/logs/logpush/logpush-job/custom-fields/) documentation

## 2025-03-06

**One-click Logpush Setup with R2 Object Storage**

We’ve streamlined the [Logpush](https://developers.cloudflare.com/logs/logpush/) setup process by integrating R2 bucket creation directly into the Logpush workflow!

Now, you no longer need to navigate multiple pages to manually create an R2 bucket or copy credentials. With this update, you can seamlessly **configure a Logpush job to R2 in just one click**, reducing friction and making setup faster and easier.

This enhancement makes it easier for customers to adopt Logpush and R2.

For more details refer to our [Logs](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/r2/) documentation.

![One-click Logpush to R2](https://developers.cloudflare.com/_astro/Oneclick.CqS1AGxh_Z157j7f.webp)

## 2024-10-08

**New fields added to Gateway-related datasets in Cloudflare Logs**

Cloudflare has introduced new fields to two Gateway-related datasets in Cloudflare Logs:

* **Gateway HTTP**: `ApplicationIDs`, `ApplicationNames`, `CategoryIDs`, `CategoryNames`, `DestinationIPContinentCode`, `DestinationIPCountryCode`, `ProxyEndpoint`, `SourceIPContinentCode`, `SourceIPCountryCode`, `VirtualNetworkID`, and `VirtualNetworkName`.

* **Gateway Network**: `ApplicationIDs`, `ApplicationNames`, `DestinationIPContinentCode`, `DestinationIPCountryCode`, `ProxyEndpoint`, `SourceIPContinentCode`, `SourceIPCountryCode`, `TransportProtocol`, `VirtualNetworkID`, and `VirtualNetworkName`.
