---
title: Collect PCAPs · Cloudflare Magic Firewall docs
description: After a packet capture is requested and the capture is collected,
  the output is contained within one or more files in PCAP file format. Before
  starting a full type packet capture, you must first follow instructions for
  configuring a bucket.
lastUpdated: 2025-09-09T15:44:21.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-firewall/packet-captures/collect-pcaps/
  md: https://developers.cloudflare.com/magic-firewall/packet-captures/collect-pcaps/index.md
---

After a packet capture is requested and the capture is collected, the output is contained within one or more files in PCAP file format. Before starting a `full` type packet capture, you must first follow instructions for [configuring a bucket](https://developers.cloudflare.com/magic-firewall/packet-captures/pcaps-bucket-setup/).

Note

Packet captures are available for Advanced Magic Firewall users. For access, contact your account team.

## Send a packet capture request

Currently, when a packet capture is requested, packets flowing at Cloudflare's global network through the Magic Transit system are captured. The default API field for this is `"system": "magic-transit"`, both for the request and response.

Note

For help determining which data center to select for a packet capture, visit <https://cloudflare.com/cdn-cgi/trace> and refer to the `colo` field. Note some data centers can be regional such as `ORD` while other names may be more specific like `ord02`. Either of these names can be used for this same field.

### Packet capture limits

**Sample and full**

* `time_limit`: The minimum value is `1` seconds and maximum value is `300` seconds.
* `packet_limit`: The minimum value is `1` packet and maximum value is `10000` packets.

**Full**

* `byte_limit`: The minimum value is `1` byte and maximum value is `1000000000` bytes.

- Dashboard

  1. In the Cloudflare dashboard, go to the **Packet captures** page in Magic Transit or Magic WAN.

     To set up a packet capture in Magic Transit: [Go to **Packet captures**](https://dash.cloudflare.com/?to=/:account/magic-transit/packet-captures/captures)

     To set up a packet capture in Magic WAN: [Go to **Packet captures**](https://dash.cloudflare.com/?to=/:account/magic-wan/packet-captures/captures)

  2. In **Captures**, select **Start a capture**.

  3. Select the **Captures** tab > **Start a capture**.

  4. Choose the type of capture you want to perform, and select **Next**.

  5. Fill out the required fields to begin the capture and then select **Start**.

  The main **Packet captures** page displays a list of captures.

- API

  The PCAPs API needs both `system` and `type` to be specified to start a capture. A PCAP's `system` is the product or logical subsystem where packets are captured, and a PCAP's `type` is how the captured packets are built into a PCAP file.

  Currently, you can only send one collect request per minute for sample PCAPs, and you can only have one running or pending full PCAP at a time.

  Full PCAP

  For full PCAP requests, refer to the required parameters listed at [Create full PCAP requests](https://developers.cloudflare.com/api/resources/magic_transit/subresources/pcaps/methods/create/). Note that full packet captures require two more parameters than sample packets.

  The full PCAP request endpoint also contains optional fields you can use to limit the amount of packets captured. Both full and sample packet requests contain an optional `filter_v1` parameter you can use to filter packets by IPv4 Source address, for example. For a full list of the filter options, refer to the parameter lists above.

  Leave `filter_v1` empty to collect all packets without any filtering.

  ```bash
  curl https://api.cloudflare.com/client/v4/accounts/{account_id}/pcaps \
  --header "X-Auth-Email: <EMAIL>" \
  --header "X-Auth-Key: <API_KEY>" \
  --header "Content-Type: application/json" \
  --data '{
    "filter_v1": {},
    "time_limit": 300,
    "packet_limit": 10000,
    "byte_limit": 100000000,
    "type": "full",
    "colo": "ORD",
    "system": "magic-transit",
    "destination_conf": "${BUCKET}"
  }'
  ```

  While the collection is in progress, the response returns the `status` field as `pending`. You must wait for the PCAP collection to complete before downloading the file. When the PCAP is ready to download, the status changes to `success`.

  ```json
  {
    "result": {
      "id": "7d7c88382f0b4d5daa9587aa45a1a877",
      "submitted": "2022-06-02T18:38:22.269047Z",
      "filter_v1": {},
      "time_limit": 300,
      "status": "pending",
      "type": "full",
      "system": "magic-transit",
      "packet_limit": 10000,
      "byte_limit": 100000000,
      "colo": "ORD",
      "destination_conf": "gs://<bucket-name>" // Ensure you use a bucket that you created and registered in the Cloudflare dashboard
    },
    "success": true,
    "errors": [],
    "messages": []
  }
  ```

  Sample PCAP

  To create a sample PCAP request, send a JSON body with the required parameter listed at [Create sample PCAP request](https://developers.cloudflare.com/api/resources/magic_transit/subresources/pcaps/methods/create/).

  Leave `filter_v1` to collect all packets without any filtering.

  ```bash
  curl https://api.cloudflare.com/client/v4/accounts/{account_id}/pcaps \
  --header "X-Auth-Email: <EMAIL>" \
  --header "X-Auth-Key: <API_KEY>" \
  --header "Content-Type: application/json" \
  --data '{
    "filter_v1": {
      "source_address": "1.2.3.4",
      "source_port": 123,
      "destination_address": "5.6.7.8",
      "destination_port": 80,
      "protocol": 6
    },
    "time_limit": 300,
    "packet_limit": 10000,
    "type": "simple",
    "system": "magic-transit"
  }'
  ```

  The response is a JSON body that contains the details of the job running to build the packet capture. The response contains a unique identifier for the packet capture request along with the details sent in the request.

  ```json
  {
    "result": {
      "id": "6d1f0aac13cd40e3900d29f5dd0e8a2b",
      "submitted": "2021-12-20T17:29:20.641845Z",
      "filter_v1": {
        "source_address": "1.2.3.4",
        "source_port": 123,
        "destination_address": "5.6.7.8",
        "destination_port": 80,
        "protocol": 6
      },
      "time_limit": 60,
      "status": "pending",
      "packets_remaining": 0,
      "type": "simple",
      "system": "magic-transit"
    },
    "success": true,
    "errors": [],
    "messages": []
  }
  ```

## Check packet capture status

* Dashboard

  1. In the Cloudflare dashboard, go to the **Packet captures** page in Magic Transit or Magic WAN.

     To set up a packet capture in Magic Transit: [Go to **Packet captures**](https://dash.cloudflare.com/?to=/:account/magic-transit/packet-captures/captures)

     To set up a packet capture in Magic WAN: [Go to **Packet captures**](https://dash.cloudflare.com/?to=/:account/magic-wan/packet-captures/captures)

  2. In **Packet captures**, select **Start a capture**.

  3. Select the **Captures** tab.

* API

  To check the status of a running job, send a request to the endpoint and specify the PCAP identifier. The PCAP identifier is received in the response of a collect request as shown in the previous step.

  ```bash
  curl https://api.cloudflare.com/client/v4/accounts/{account_id}/pcaps/{pcap_id} \
  --header 'X-Auth-Email: <EMAIL>' \
  --header 'X-Auth-Key: <API_KEY>'
  ```

  The response will be similar to the one received when requesting a PCAP collection.

  ```json
  {
    "result": {
      "id": "6d1f0aac13cd40e3900d29f5dd0e8a2b",
      "submitted": "2021-12-20T17:29:20.641845Z",
      "filter_v1": {
        "source_address": "1.2.3.4",
        "source_port": 123,
        "destination_address": "5.6.7.8",
        "destination_port": 80,
        "protocol": 6
      },
      "time_limit": 120,
      "status": "success",
      "packets_remaining": 0,
      "type": "simple",
      "system": "magic-transit"
    },
    "success": true,
    "errors": [],
    "messages": []
  }
  ```

The capture status displays one of the following options:

* **Complete:** The capture request is done and ready for download.
* **In progress:** The capture request was captured but still processing.
* **Failure:** The capture failed. If this occurs, verify your ownership information.

## Download packet captures

After your request finishes processing, you can download your packet captures.

* Dashboard

  1. In the Cloudflare dashboard, go to the **Packet captures** page in Magic Transit or Magic WAN.

     To set up a packet capture in Magic Transit: [Go to **Packet captures**](https://dash.cloudflare.com/?to=/:account/magic-transit/packet-captures/captures)

     To set up a packet capture in Magic WAN: [Go to **Packet captures**](https://dash.cloudflare.com/?to=/:account/magic-wan/packet-captures/captures)

  2. In **Packet captures**, select **Start a capture**.

  3. Select the **Captures** tab.

  4. Locate your packet capture you want to download, and select **Download**.

  Packet captures are available to download when the **Status** displays **Success**.

* API

  For more information on how to process multiple saved capture files into a single output file, refer to [Wireshark's mergecap documentation](https://www.wireshark.org/docs/man-pages/mergecap.html).

  **Full PCAPs**

  To obtain full PCAPs, download the files from the bucket specified in `destination_conf` after the PCAP's status is `success`. You may find multiple files named `pcap_<pcap_id>.pcap` per capture as captures can occur across multiple machines.

  **Sample PCAPs**

  Once the sample PCAP collection is complete, you can download the PCAP by specifying the PCAP identifier used earlier.

  ```bash
  curl https://api.cloudflare.com/client/v4/accounts/{account_id}/pcaps/{pcap_id}/download \
  --header 'X-Auth-Email: <EMAIL>' \
  --header 'X-Auth-Key: <API_KEY>' \
  --output download.pcap
  ```

## List packet captures

* Dashboard

  1. In the Cloudflare dashboard, go to the **Packet captures** page in Magic Transit or Magic WAN.

     To set up a packet capture in Magic Transit: [Go to **Packet captures**](https://dash.cloudflare.com/?to=/:account/magic-transit/packet-captures/captures)

     To set up a packet capture in Magic WAN: [Go to **Packet captures**](https://dash.cloudflare.com/?to=/:account/magic-wan/packet-captures/captures)

  2. In **Packet captures**, select **Start a capture**.

  3. Select the **Captures** tab.

  The list of packet captures associated with your account displays.

* API

  To view a list of sent requests, use the following command:

  ```bash
  curl https://api.cloudflare.com/client/v4/accounts/{account_id}/pcaps \
  --header "X-Auth-Email: <EMAIL>" \
  --header "X-Auth-Key: <API_KEY>"
  ```

  The response returns an array that includes up to 50 sent requests, which includes completed and ongoing requests.

  ```json
  {
    "result": [
      {
        "id": "43adab5adeca4dab9c51f4b7f70f2ec3",
        "submitted": "2021-12-15T03:04:09.277394Z",
        "filter_v1": {},
        "time_limit": 120,
        "status": "success",
        "packets_remaining": 0,
        "type": "simple",
        "system": "magic-transit"
      }
    ],
    "success": true,
    "errors": [],
    "messages": []
  }
  ```
