---
title: Querying Magic Transit tunnel bandwidth analytics with GraphQL ·
  Cloudflare Magic Transit docs
description: In this example, you are going to use the GraphQL Analytics API to
  query Magic Transit ingress tunnel traffic over a specified time period.
lastUpdated: 2025-03-27T12:39:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-transit/analytics/query-bandwidth/
  md: https://developers.cloudflare.com/magic-transit/analytics/query-bandwidth/index.md
---

In this example, you are going to use the GraphQL Analytics API to query Magic Transit ingress tunnel traffic over a specified time period.

The following API call will request Magic Transit ingress tunnel traffic over a one-hour period and output the requested fields. Be sure to replace `<CLOUDFLARE_ACCOUNT_TAG>` with your account ID, `<EMAIL>`, `<API_KEY>`[1](#user-content-fn-1) (legacy) or `<API_TOKEN>`[2](#user-content-fn-2) (preferred method) with your API credentials, and adjust the `datetime_geq` and `datetime_leq` values as needed.

The following example queries for ingress traffic. To query for egress, change the value in the direction filter.

## API Call

```bash
PAYLOAD='{ "query":
  "query GetTunnelHealthCheckResults($accountTag: string, $datetimeStart: string, $datetimeEnd: string) {
      viewer {
        accounts(filter: {accountTag: $accountTag}) {
          magicTransitTunnelTrafficAdaptiveGroups(
            limit: 100,
            filter: {
              datetime_geq: $datetimeStart,
              datetime_lt:  $datetimeEnd,
              direction: $direction
            }
          ) {
            avg {
              bitRateFiveMinutes
            }
            dimensions {
              tunnelName
              datetimeFiveMinutes
            }
          }
        }
      }
  }",
    "variables": {
      "accountTag": "<CLOUDFLARE_ACCOUNT_TAG>",
      "direction": "ingress",
      "datetimeStart": "2022-05-04T11:00:00.000Z",
      "datetimeEnd": "2022-05-04T12:00:00.000Z"
    }
  }
}'


# curl with Legacy API Key
curl https://api.cloudflare.com/client/v4/graphql \
--header "X-Auth-Email: <EMAIL>" \
--header "X-Auth-Key: <API_KEY>" \
--header "Accept: application/json" \
--header "Content-Type: application/json" \
--data "$(echo $PAYLOAD)"


# curl with API Token
curl https://api.cloudflare.com/client/v4/graphql \
--header "Authorization: Bearer <API_TOKEN>" \
--header "Accept: application/json" \
--header "Content-Type: application/json" \
--data "$(echo $PAYLOAD)"
```

The returned values represent the total bandwidth in bits/second during the five minute interval for a particular tunnel. To use aggregations other than five minutes, make sure that you use the same window for both your metric and date time. For example, to see hourly groups, use `bitRateHour` and `datetimeHour`.

The result will be in JSON (as requested), so piping the output to `jq` will make it easier to read, like in the following example:

```bash
curl https://api.cloudflare.com/client/v4/graphql \
--header "Authorization: Bearer <API_TOKEN>" \
--header "Accept: application/json" \
--header "Content-Type: application/json" \
--data "$(echo $PAYLOAD)" | jq .


## Example response:
#=> {
#=>   "data": {
#=>     "viewer": {
#=>       "accounts": [
#=>         {
#=>           "magicTransitTunnelTrafficAdaptiveGroups": [
#=>             {
#=>               avg: { bitRateFiveMinutes:  327680 },
#=>               dimensions: {
#=>                 datetimeFiveMinute: '2021-05-12T22:00-00:00',
#=>                 tunnelName: 'tunnel_name'
#=>               }
#=>             },
#=>             {
#=>               avg: { bitRateFiveMinutes:  627213680 },
#=>               dimensions: {
#=>                 datetimeFiveMinute: '2021-05-12T22:05-00:00',
#=>                 tunnelName: 'another_tunnel'
#=>              }
#=>             }
#=>           ]
#=>         }
#=>       ]
#=>     }
#=>   },
#=>   "errors": null
#=> }
```

## Footnotes

1. Refer to [Authenticate with a Cloudflare API key](https://developers.cloudflare.com/analytics/graphql-api/getting-started/authentication/api-key-auth/) for more information. [↩](#user-content-fnref-1)

2. Refer to [Configure an Analytics API token](https://developers.cloudflare.com/analytics/graphql-api/getting-started/authentication/api-token-auth/) for more information on configuration and permissions. [↩](#user-content-fnref-2)
