---
title: Get started · Cloudflare Network Interconnect docs
description: "Eligibility for CNI and port availability is determined in
  coordination with your Cloudflare account team. Notably:"
lastUpdated: 2025-10-20T09:23:25.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/network-interconnect/get-started/
  md: https://developers.cloudflare.com/network-interconnect/get-started/index.md
---

## Prerequisites

### CNI port availability

Eligibility for CNI and port availability is determined in coordination with your Cloudflare account team. Notably:

* CNI ports are currently offered at no charge to Enterprise customers. Non-Enterprise customers (and any third party) may peer with Cloudflare via Internet Exchange/PNI according to our [open peering policy](https://www.cloudflare.com/peering-policy/).

* CNI provides benefits for certain Cloudflare products. Refer to [Product use cases](https://developers.cloudflare.com/network-interconnect/get-started/#product-use-cases) section to confirm that CNI is the right solution for your technical and business requirements.

* CNI is available in a subset of Cloudflare data centers:

  * The type of dataplane offered in that location (v1.0 or v1.1) will determine specifications of the supported connection, such as the MTU.
  * The diversity offered in the location will vary.

### Product use cases

CNI provides a private point-to-point IP connection with Cloudflare. There are two dataplanes that come with different technical specifications.

| | Dataplane v1.0 | Dataplane v1.1 |
| - | - | - |
| **Magic Transit Direct Server Return (DSR)** DDoS protection for all ingress traffic from the Internet to your public network. Send egress traffic via your ISP. | Supported with a GRE tunnel established over the interconnect circuit. | Supported with or without a GRE tunnel established over the interconnect circuit. |
| **Magic Transit with Egress** DDoS protection for all ingress traffic from the Internet to your public network. Send egress traffic via Cloudflare. | Supported with a GRE tunnel established over the interconnect circuit. | Supported with a GRE tunnel established over the interconnect circuit. |
| **Magic WAN and Zero Trust** Build a secure, private network backbone connecting your Zero Trust users and applications with all your sites, data centers, and clouds. | Supported with a GRE tunnel established over the interconnect circuit. | Supported with or without a GRE tunnel established over the interconnect circuit. |
| **Peering** Exchange public routes with a single Cloudflare PoP (Point of Presence). | Supported. All customers connecting with the edge data center will exchange public routes at that PoP with AS13335. Connectivity is established at each individual PoP. Routes for other edge locations in Cloudflare's network may not be available. Routes for customer-advertised prefixes will be available only in the connected PoP. | Supported. All customers connecting with the edge data center will exchange public routes at that PoP with AS13335. Connectivity is established at each individual PoP. Routes for other edge locations in Cloudflare's network may not be available. Routes for customer-advertised prefixes will be available only in the connected PoP. |
| **Application Security and Performance** Improve the performance and security of your web applications | **Supported via peering**: Customers can use Argo Smart Routing to direct origin traffic via the edge peering connection when it is determined to be the lowest latency option. Customers must maintain a direct Internet connection which will always be used for a portion of traffic and during failure scenarios. **Supported Via Magic Transit**: Customers may configure any product with an origin server IP address that is protected by Magic Transit. Magic Transit will direct this traffic via the overlay and customer can control interconnect next-hops using the Magic networking routing table. | **Supported via peering**: Customers can use Argo Smart Routing to direct origin traffic via the edge peering connection when it is determined to be the lowest latency option. Customers must maintain a direct Internet connection which will always be used for a portion of traffic and during failure scenarios. **Supported Via Magic Transit**: Customers may configure any product with an origin server IP address that is protected by Magic Transit. Magic Transit will direct this traffic via the overlay and customer can control interconnect next-hops using the Magic networking routing table. |

For more details refer to the [prerequisites section](https://developers.cloudflare.com/network-interconnect/get-started/#prerequisites).

### Technical specifications

* **Supported port types (Direct CNI):** 10G-LR (single-mode fiber) and 100G-LR4 (single-mode fiber).

* **Distance limitations:** Cloudflare does not support optical links longer than 10 km. For longer distances, you must use intermediate hardware or a third-party provider to extend the connection.

* **IP addressing:** All CNI connections use a `/31` subnet for point-to-point IP connectivity between your router and Cloudflare's.

* **VLAN support:** CNI ports may be assigned a single 802.1Q VLAN tag.

* **MTU considerations:**

  * **Dataplane 1.0:** Requires GRE tunneling for Magic Transit / WAN traffic, limiting the MTU to 1,476 bytes.
  * **Dataplane 1.1:** Supports a native 1,500-byte MTU for traffic from Cloudflare to you (ingress), but still requires a 1,476-byte MTU for traffic from you to Cloudflare (egress).

* **Bidirectional Forwarding Detection (BFD):** BFD provides fast failure detection for BGP sessions and is supported on direct connections. To enable BFD, contact your account team. Note that BFD on a CNI does not impact the failover time for Magic Transit / WAN tunnels, which rely on separate health checks.

* **Link Aggregation Control Protocol (LACP)**: To increase bandwidth and provide link resiliency, Cloudflare supports combining multiple physical CNI ports into a single logical channel using LACP. You can bundle multiple connections to increase total throughput and add redundancy to your private connection with Cloudflare.

### Performance characteristics

The following are the maximum throughput rates supported by the CNI connection. Actual performance will depend on your specific use case and configuration.

| Direction (use case) | 10G Circuit | 100G Circuit |
| - | - | - |
| From Cloudflare to Customer (all use cases) | Up to 10 Gbps | Up to 100 Gbps |
| From Customer to Cloudflare (peering use case) | Up to 10 Gbps | Up to 100 Gbps |
| From Customer to Cloudflare (Magic Transit/WAN) | Up to 1 Gbps per GRE tunnel over the CNI | Up to 1 Gbps per GRE tunnel over the CNI |

### Service Expectations

Consider the following service levels when planning your deployment:

* **No Formal SLA**:

  * CNI is currently offered at no charge and without a formal Service Level Agreement (SLA).
  * Cloudflare will work to restore CNI service in the event of a Cloudflare issue. In some Cloudflare data centers the recovery time could be several days. Therefore we always recommend backup connectivity to a different device or via an Internet tunnel.

* **Observability**: There is no visibility of the interconnect config/status within the Cloudflare dashboard.

* **Availability**: While network-resilient locations are designed to maintain connectivity during maintenance, single-homed locations can experience full service disruption.

* **Backup Connectivity**: You are required to maintain alternative Internet connectivity as a backup for all CNI implementations.

* **BGP**: Customers must have a BGP session established for Dataplane 1.0/1.1 to be operational.

## Location Alignment

### Available Locations

Direct connections are available at any Cloudflare data center where you are also located. Make sure to check whether the location of interest has the right dataplane version and diversity requirements for your use case. Refer to [available locations](https://developers.cloudflare.com/network-interconnect/static/cni-locations-04-08-2025.pdf) (PDF) for details.

### Connectivity Partners

Cloudflare partners with leading global providers, including: Console Connect, CoreSite, Digital Realty, Equinix Fabric, Megaport, PacketFabric, and Zayo.

## End-to-End Implementation Workflow

The process of provisioning a CNI typically takes two to four weeks, depending on the complexity of implementation and third-party provider timelines. The most common delays occur during the physical connection phase, which is outside of Cloudflare's direct control.

1. **Submit Request**: Work with your account team to create a CNI request ticket, providing your desired CNI type, location, use case, and technical details. An Implementation Manager will be assigned to guide the process.

2. **Review Configuration**: The Implementation Manager will provide a detailed configuration document covering IP addressing, VLANs, and other technical specifications. You must review and approve this document.

3. **Order Connection**:

   * For a Direct Interconnect, you will receive a Letter of Authorization (LOA) from Cloudflare to order the physical cross-connect from the data center facility operator.
   * For a Partner Interconnect, you will use the provided details to order a virtual circuit from the partner's portal.

4. **Configure Network**: Both Cloudflare and your network team will configure the respective network devices according to the approved document.

5. **Test and Verify**: Once the connection is physically established, teams will perform basic connectivity tests (for example, ping) and verify that the BGP session can be established.

6. **Activate Services**: Configure your Cloudflare products (for example, Magic Transit) to route traffic over the new CNI. The Implementation Manager will verify end-to-end traffic flow before marking the deployment as complete.

7. [Add maintenance notifications](https://developers.cloudflare.com/network-interconnect/monitoring-and-alerts/#enable-cloudflare-status-maintenance-notification).

8. Enable tunnel health checks for Magic [Transit](https://developers.cloudflare.com/magic-transit/how-to/configure-tunnel-endpoints/#add-tunnels) / [WAN](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-tunnel-endpoints/#add-tunnels).

## How-To guides

### How-To: Provision a Direct Interconnect

1. **Project Kickoff**: In an initial kickoff call, you will confirm the scope and timeline with Cloudflare. Be prepared to provide the following information:

   * desired colocation facility
   * required port speeds (10G or 100G)
   * BGP ASN for Peering/Magic Transit
   * BGP password (optional)

2. **Order Cross-Connect**: Cloudflare will issue a Letter of Authorization (LOA). This document grants you permission to order a physical cross-connect between your equipment and a specific port on Cloudflare's hardware within the data center. The end-to-end process for ordering a cross-connect can take one to two weeks or more, depending on the facility provider. Cloudflare's demarcation is the port that is specified in the LOA: you are responsible for the deployment, provisioning and ongoing support and operation of this connection, and the commercial relationships with the facility provider and any third-party connectivity providers.

### How-To: Provision a Partner Interconnect

Cloudflare partners with leading connectivity providers globally. To provision a Partner Interconnect, you will initiate a connection request from your chosen provider's administrative portal. Cloudflare will then review and accept the request to activate the virtual circuit.

### How-To: Configure BGP and routing

Once your physical cross-connect or virtual circuit is provisioned, the next phase is to configure IP routing using Border Gateway Protocol (BGP). This process typically takes about one week to complete.

#### Step 1: IP Address provisioning

1. Cloudflare will send you a set of IPv4 and IPv6 addresses for your connection.
2. Assign the provided IPs to your router's interface that connects to Cloudflare.
3. Perform ping tests between your router and Cloudflare's router to confirm that the physical or virtual link is active and passing packets correctly.
   * **For Partner Interconnects**: If you are using a partner like Megaport, ensure you have configured the correct VLAN provided by your Customer Success Manager, as an incorrect VLAN can cause IP provisioning to fail.

#### Step 2: BGP session establishment

After you confirm connectivity with successful ping tests, the next step is to establish the BGP session.

1. Cloudflare will configure its side of the BGP session, and notify you once ready.
2. You will configure your side of the BGP session and accept the routes you need.
3. Once the session is established, traffic will begin to flow over the CNI. Contact your solutions engineer to verify that traffic is routing as expected.

#### BGP configuration options and use cases

Depending on the Cloudflare services you use, your BGP configuration may vary:

* **Standard Peering**: This is the most common scenario, where BGP is used to exchange routes between your network and Cloudflare. Cloudflare learns your network routes, which is useful for services like CDN-only deployments or on-demand Magic Transit. It is important to note that this is not peering with the Magic Transit routing table, which is global. Instead, this is peering with the specific data center's Internet edge network. This means that prefixes Cloudflare learns via CNI remain local to that specific data center and are not propagated to other Cloudflare locations.
* **Magic Transit with Controlled Advertisement**: Magic Transit customers can use a second BGP session to control which prefixes are advertised to the Internet. In this setup, Cloudflare advertises no prefixes to you, and you advertise only the specific prefixes you want Cloudflare to announce on your behalf.

#### Important note on accepting routes from Cloudflare

If you wish to use the CNI for egress traffic from your network to Cloudflare-advertised prefixes (such as anycast or BYOIP addresses), you can accept the BGP prefixes you receive from Cloudflare (typically there will be around 4,000 to 6,000 routes advertised by Cloudflare).

#### Optional: Bidirectional Forwarding Detection (BFD)

For configurations that are highly sensitive to packet loss, Bidirectional Forwarding Detection (BFD) can be enabled to monitor link status on a sub-second basis.

* BFD works by sending a rapid stream of small packets over the BGP session. If a few packets are lost, the link is immediately considered down, enabling faster failover.
* BFD is only supported for Direct Interconnect connections. Contact your account team to enable it.
* Note that enabling BFD on a CNI BGP session does not change the failover time for Magic Transit/WAN, which is controlled by its own tunnel health checks.
