---
title: Use Gzip compression for CSV files · Cloudflare Rules docs
description: Create a compression rule to set Gzip compression as the preferred
  compression method for CSV files.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/compression-rules/examples/gzip-for-csv/
  md: https://developers.cloudflare.com/rules/compression-rules/examples/gzip-for-csv/index.md
---

* Dashboard

  The following example rule will configure Gzip compression as the preferred compression method for CSV files. If the visitor does not support this algorithm, Cloudflare will try to compress the response using a different algorithm supported by the visitor.

  **When incoming requests match**

  * Custom filter expression:
    * *File extension* *equals* `csv`

  **Then**

  * **Compression options**: Custom
  * **Define a custom order for compression types**: `Gzip`, `Auto`

* API

  The following example sets the rules of an existing [entry point ruleset](https://developers.cloudflare.com/ruleset-engine/about/rulesets/#entry-point-ruleset) (with ID `{ruleset_id}`) for the `http_response_compression` phase to a single compression rule, using the [Update a zone ruleset](https://developers.cloudflare.com/api/resources/rulesets/methods/update/) operation:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Response Compression Write`
  * `Config Settings Write`
  * `Dynamic URL Redirects Write`
  * `Cache Settings Write`
  * `Custom Errors Write`
  * `Origin Write`
  * `Managed headers Write`
  * `Zone Transform Rules Write`
  * `Mass URL Redirects Write`
  * `Magic Firewall Write`
  * `L4 DDoS Managed Ruleset Write`
  * `HTTP DDoS Managed Ruleset Write`
  * `Sanitize Write`
  * `Transform Rules Write`
  * `Select Configuration Write`
  * `Bot Management Write`
  * `Zone WAF Write`
  * `Account WAF Write`
  * `Account Rulesets Write`
  * `Logs Write`
  * `Logs Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/$RULESET_ID" \
    --request PUT \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "rules": [
          {
              "ref": "use_gzip_for_csv",
              "expression": "http.request.uri.path.extension eq \"csv\"",
              "action": "compress_response",
              "action_parameters": {
                  "algorithms": [
                      {
                          "name": "gzip"
                      },
                      {
                          "name": "auto"
                      }
                  ]
              }
          }
      ]
    }'
  ```

  Use the `ref` field to get stable rule IDs across updates when using Terraform. Adding this field prevents Terraform from recreating the rule on changes. For more information, refer to [Troubleshooting](https://developers.cloudflare.com/terraform/troubleshooting/rule-id-changes/#how-to-keep-the-same-rule-id-between-modifications) in the Terraform documentation.
