---
title: Common API calls · Cloudflare Rules docs
description: The following sections provide examples of common API calls for
  managing custom error assets at the zone level.
lastUpdated: 2025-06-04T08:56:32.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/custom-errors/api-calls/
  md: https://developers.cloudflare.com/rules/custom-errors/api-calls/index.md
---

The following sections provide examples of common API calls for managing custom error assets at the zone level.

To perform the same operations at the account level, use the corresponding account-level API endpoints.

### Create a custom error asset

The following `POST` request creates a new custom error asset in a zone based on the provided URL:

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/custom_pages/assets" \
--header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
--json '{
  "name": "500_error_template",
  "description": "Standard 5xx error template page",
  "url": "https://example.com/errors/500_template.html"
}'
```

```json
{
  "result": {
    "name": "500_error_template",
    "description": "Standard 5xx error template page",
    "url": "https://example.com/errors/500_template.html",
    "last_updated": "2025-02-10T11:36:07.810215Z",
    "size_bytes": 2048
  },
  "success": true
}
```

To create an asset at the account level, use the account-level endpoint:

```txt
https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/custom_pages/assets
```

### List custom error assets

The following `GET` request retrieves a list of custom error assets configured in the zone:

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/custom_pages/assets" \
--header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
```

```json
{
  "result": [
    {
      "name": "500_error_template",
      "description": "Standard 5xx error template page",
      "url": "https://example.com/errors/500_template.html",
      "last_updated": "2025-02-10T11:36:07.810215Z",
      "size_bytes": 2048
    }
    // ...
  ],
  "success": true,
  "errors": [],
  "messages": [],
  "result_info": {
    "count": 2,
    "page": 1,
    "per_page": 20,
    "total_count": 2,
    "total_pages": 1
  }
}
```

To retrieve a list of assets at the account level, use the account-level endpoint:

```txt
https://api.cloudflare.com/client/v4/accounts/$ZONE_ID/custom_pages/assets
```

### Update a custom error asset

The following `PUT` request updates the URL of an existing custom error asset at the zone level named `500_error_template`:

```bash
curl --request PUT \
"https://api.cloudflare.com/client/v4/zones/$ZONE_ID/custom_pages/assets/500_error_template" \
--header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
--json '{
  "description": "Standard 5xx error template page",
  "url": "https://example.com/errors/500_new_template.html"
}'
```

```json
{
  "result": {
    "name": "500_error_template",
    "description": "Standard 5xx error template page",
    "url": "https://example.com/errors/500_new_template.html",
    "last_updated": "2025-02-10T13:13:07.810215Z",
    "size_bytes": 3145
  },
  "success": true
}
```

You can update the asset description and URL. You cannot update the asset name after creation.

If you provide the same URL when updating an asset, Cloudflare will fetch the URL again, along with its resources.

To update an asset at the account level, use the account-level endpoint:

```txt
https://api.cloudflare.com/client/v4/accounts/{account_id}/custom_pages/assets/{asset_name}
```

### Get a custom error asset

The following `GET` request retrieves the details of an existing custom error asset at the zone level named `500_error_template`:

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/custom_pages/assets/500_error_template" \
--header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
```

```json
{
  "result": {
    "name": "500_error_template",
    "description": "Standard 5xx error template page",
    "url": "https://example.com/errors/500_new_template.html",
    "last_updated": "2025-02-10T13:13:07.810215Z",
    "size_bytes": 3145
  },
  "success": true
}
```

To retrieve an asset at the account level, use the account-level endpoint:

```txt
https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/custom_pages/assets/$ASSET_NAME
```

### Delete a custom error asset

The following `DELETE` request deletes an existing custom error asset at the zone level named `500_error_template`:

```bash
curl --request DELETE \
"https://api.cloudflare.com/client/v4/zones/$ZONE_ID/custom_pages/assets/500_error_template" \
--header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
```

If the request is successful, the response will have a `204` HTTP status code.

To delete an asset at the account level, use the account-level endpoint:

```txt
https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/custom_pages/assets/$ASSET_NAME
```

### Get error page

This example obtains the current configuration for the `Rate limiting block` error page (with ID `ratelimit_block`).

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Custom Pages Write`
* `Custom Pages Read`
* `Zone Settings Write`
* `Zone Settings Read`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_IDENTIFIER/custom_pages/ratelimit_block" \
  --request GET \
  --header "X-Auth-Email: $CLOUDFLARE_EMAIL" \
  --header "X-Auth-Key: $CLOUDFLARE_API_KEY"
```

```json
{
  "result": {
    "id": "ratelimit_block",
    "description": "Rate limit Block",
    "required_tokens": [],
    "preview_target": "block:rate-limit",
    "created_on": "2025-06-03T08:33:17.091587Z",
    "modified_on": "2025-06-03T08:33:17.091587Z",
    "url": null,
    "state": "default"
  },
  "success": true,
  "errors": [],
  "messages": []
}
```

The response indicates that the page is currently set to the Cloudflare default page (`"state": "default"`).

For a list of error page identifiers, refer to [Error page types](https://developers.cloudflare.com/rules/custom-errors/reference/error-page-types/).

### Update error page

This example defines a custom error page for `Rate limiting block` errors (with ID `ratelimit_block`) based on the provided URL.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Custom Pages Write`
* `Zone Settings Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_IDENTIFIER/custom_pages/ratelimit_block" \
  --request PUT \
  --header "X-Auth-Email: $CLOUDFLARE_EMAIL" \
  --header "X-Auth-Key: $CLOUDFLARE_API_KEY" \
  --json '{
    "state": "customized",
    "url": "https://example.com/rate_limiting_block_error_page.html"
  }'
```

```json
{
  "result": {
    "id": "ratelimit_block",
    "description": "Rate limit Block",
    "required_tokens": [],
    "preview_target": "block:rate-limit",
    "created_on": "2025-06-03T08:33:17.091587Z",
    "modified_on": "2025-06-03T08:35:32.639114Z",
    "url": "https://example.com/rate_limiting_block_error_page.html",
    "state": "customized"
  },
  "success": true,
  "errors": [],
  "messages": []
}
```

To set the error page back to the default page, use `"state": "default"` in the request body.

For a list of error page identifiers, refer to [Error page types](https://developers.cloudflare.com/rules/custom-errors/reference/error-page-types/).
