---
title: URL Rewrite Rules · Cloudflare Rules docs
description: "You can manipulate the URL of a request through different
  operations, namely rewrites and redirects:"
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/transform/url-rewrite/
  md: https://developers.cloudflare.com/rules/transform/url-rewrite/index.md
---

You can manipulate the URL of a request through different operations, namely rewrites and redirects:

* **URL rewrite**: A server-side operation that converts a source URL into a target URL. It occurs before a web server has fully processed a request. A rewrite is not visible to website visitors, since the URL displayed in the browser does not change. Configure URL Rewrite Rules to perform rewrites on the Cloudflare global network without reaching your web server.

* **URL redirect**: A client-side operation that converts a source URL into a target URL. It occurs after the web server has loaded the initial URL. In this case, a website visitor can notice the URL changing when the redirect occurs. Refer to [Redirects](https://developers.cloudflare.com/rules/url-forwarding/) to learn more about configuring redirects.

Use a URL rewrite rule to return the content of a URL while displaying a different URL in the browser. You can rewrite the URI path, the query string, or both.

Warning

You cannot rewrite the hostname using a URL rewrite rule. To rewrite the hostname, use an [origin rule](https://developers.cloudflare.com/rules/origin-rules/features/#dns-record).

For more complex rewrite logic, consider using [Snippets](https://developers.cloudflare.com/rules/snippets/).

## Static and dynamic rewrites

URL Rewrite Rules can perform static or dynamic rewrites:

* **Static rewrite**: Replaces a given part of a request URL (path or query string) with a static string.
* **Dynamic rewrite**: Supports more advanced scenarios where you use a rewrite expression to define the resulting path or query string.

Create URL Rewrite Rules [in the dashboard](https://developers.cloudflare.com/rules/transform/url-rewrite/create-dashboard/), [via Cloudflare API](https://developers.cloudflare.com/rules/transform/url-rewrite/create-api/), or [using Terraform](https://developers.cloudflare.com/terraform/additional-configurations/transform-rules/#create-a-url-rewrite-rule).

## Serve images from custom paths

When using Cloudflare Images, you can use URL Rewrite Rules to serve images from a custom path. For more information, refer to [Serve images from custom domains](https://developers.cloudflare.com/images/manage-images/serve-images/serve-from-custom-domains/).

## Troubleshooting

When troubleshooting URL Rewrite Rules, use [Cloudflare Trace](https://developers.cloudflare.com/rules/trace-request/) to determine if a rule is triggering for a specific URL.
