---
title: Update and deploy rulesets · Cloudflare Ruleset Engine docs
description: "You can use the API to update:"
lastUpdated: 2025-08-18T14:27:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rulesets-api/update/
  md: https://developers.cloudflare.com/ruleset-engine/rulesets-api/update/index.md
---

You can use the API to update:

* The basic properties of a ruleset (currently only the description)
* The list of rules in a ruleset

Use one of the following API endpoints:

* [Update an account ruleset](https://developers.cloudflare.com/api/resources/rulesets/methods/update/)\
  `PUT /accounts/{account_id}/rulesets/{ruleset_id}`
* [Update an account entry point ruleset](https://developers.cloudflare.com/api/resources/rulesets/subresources/phases/methods/update/)\
  `PUT /accounts/{account_id}/rulesets/phases/{phase_name}/entrypoint`
* [Update a zone ruleset](https://developers.cloudflare.com/api/resources/rulesets/methods/update/)\
  `PUT /zones/{zone_id}/rulesets/{ruleset_id}`
* [Update a zone entry point ruleset](https://developers.cloudflare.com/api/resources/rulesets/subresources/phases/methods/update/)\
  `PUT /zones/{zone_id}/rulesets/phases/{phase_name}/entrypoint`

Note

You cannot update the name of the ruleset or its type. Do not include these fields in the `data` field of your `PUT` request.

## Example - Set the rules of a ruleset

The following `PUT` request defines the list of rules of a ruleset, setting it to a single rule. You must include all the rules you want to associate with the ruleset in every request.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Response Compression Write`
* `Config Settings Write`
* `Dynamic URL Redirects Write`
* `Cache Settings Write`
* `Custom Errors Write`
* `Origin Write`
* `Managed headers Write`
* `Zone Transform Rules Write`
* `Mass URL Redirects Write`
* `Magic Firewall Write`
* `L4 DDoS Managed Ruleset Write`
* `HTTP DDoS Managed Ruleset Write`
* `Sanitize Write`
* `Transform Rules Write`
* `Select Configuration Write`
* `Bot Management Write`
* `Zone WAF Write`
* `Account WAF Write`
* `Account Rulesets Write`
* `Logs Write`
* `Logs Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/$RULESET_ID" \
  --request PUT \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "rules": [
        {
            "action": "execute",
            "action_parameters": {
                "id": "<MANAGED_RULESET_ID>"
            },
            "expression": "true"
        }
    ]
  }'
```

```json
{
  "result": {
    "id": "<RULESET_ID>",
    "name": "Zone-level phase entry point ruleset",
    "description": "This ruleset executes a managed ruleset.",
    "kind": "zone",
    "version": "4",
    "rules": [
      {
        "id": "<RULE_ID>",
        "version": "2",
        "action": "execute",
        "expression": "true",
        "action_parameters": {
          "id": "<MANAGED_RULESET_ID>"
        },
        "last_updated": "2025-03-17T15:42:37.917815Z"
      }
    ],
    "last_updated": "2025-03-17T15:42:37.917815Z",
    "phase": "http_request_firewall_managed"
  },
  "success": true,
  "errors": [],
  "messages": []
}
```

## Example - Deploy a ruleset

To deploy a ruleset, create a rule with `"action": "execute"` that executes the ruleset, and add the ruleset ID to the `action_parameters` field in the `id` parameter.

The following `PUT` request deploys a managed ruleset to the `http_request_firewall_managed` phase of a zone (`$ZONE_ID`).

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Response Compression Write`
* `Config Settings Write`
* `Dynamic URL Redirects Write`
* `Cache Settings Write`
* `Custom Errors Write`
* `Origin Write`
* `Managed headers Write`
* `Zone Transform Rules Write`
* `Mass URL Redirects Write`
* `Magic Firewall Write`
* `L4 DDoS Managed Ruleset Write`
* `HTTP DDoS Managed Ruleset Write`
* `Sanitize Write`
* `Transform Rules Write`
* `Select Configuration Write`
* `Bot Management Write`
* `Zone WAF Write`
* `Account WAF Write`
* `Account Rulesets Write`
* `Logs Write`
* `Logs Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/phases/http_request_firewall_managed/entrypoint" \
  --request PUT \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "rules": [
        {
            "action": "execute",
            "action_parameters": {
                "id": "<MANAGED_RULESET_ID>"
            },
            "expression": "true",
            "description": "Execute Cloudflare Managed Ruleset on my phase entry point ruleset"
        }
    ]
  }'
```

```json
{
  "result": {
    "id": "<RULESET_ID>",
    "name": "Zone-level phase entry point ruleset",
    "description": "",
    "kind": "zone",
    "version": "4",
    "rules": [
      {
        "id": "<RULE_ID_1>",
        "version": "1",
        "action": "execute",
        "action_parameters": {
          "id": "<MANAGED_RULESET_ID>",
          "version": "latest"
        },
        "expression": "true",
        "description": "Execute Cloudflare Managed Ruleset on my phase entry point ruleset",
        "last_updated": "2025-03-21T11:02:08.769537Z",
        "ref": "<RULE_REF_1>",
        "enabled": true
      }
    ],
    "last_updated": "2025-03-21T11:02:08.769537Z",
    "phase": "http_request_firewall_managed"
  },
  "success": true,
  "errors": [],
  "messages": []
}
```

For more information on deploying rulesets, refer to [Deploy rulesets](https://developers.cloudflare.com/ruleset-engine/basic-operations/deploy-rulesets/).

## Example - Update ruleset description

The following `PUT` request updates the description of an existing ruleset or phase entry point.

The response will include the complete ruleset definition, including all the rules.

Note

You cannot update the description or the rules in a managed ruleset. You can only [define overrides](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/override-managed-ruleset/) to customize the ruleset behavior.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Response Compression Write`
* `Config Settings Write`
* `Dynamic URL Redirects Write`
* `Cache Settings Write`
* `Custom Errors Write`
* `Origin Write`
* `Managed headers Write`
* `Zone Transform Rules Write`
* `Mass URL Redirects Write`
* `Magic Firewall Write`
* `L4 DDoS Managed Ruleset Write`
* `HTTP DDoS Managed Ruleset Write`
* `Sanitize Write`
* `Transform Rules Write`
* `Select Configuration Write`
* `Bot Management Write`
* `Zone WAF Write`
* `Account WAF Write`
* `Account Rulesets Write`
* `Logs Write`
* `Logs Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/$RULESET_ID" \
  --request PUT \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "description": "My updated phase entry point ruleset"
  }'
```

```json
{
  "result": {
    "id": "<RULESET_ID>",
    "name": "Zone entry point",
    "description": "My updated phase entry point ruleset",
    "kind": "zone",
    "version": "4",
    "rules": [
      // (...)
    ],
    "last_updated": "2025-03-30T10:49:11.006109Z",
    "phase": "http_request_firewall_managed"
  },
  "success": true,
  "errors": [],
  "messages": []
}
```
