---
title: Enable mTLS · Cloudflare SSL/TLS docs
description: You can enable mutual Transport Layer Security (mTLS) for any hostname.
lastUpdated: 2025-10-28T14:13:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/client-certificates/enable-mtls/
  md: https://developers.cloudflare.com/ssl/client-certificates/enable-mtls/index.md
---

You can enable mutual Transport Layer Security (mTLS) for any hostname.

To enable mTLS for a host from the Cloudflare dashboard:

1. In the Cloudflare dashboard, go to the **Client Certificates** page.

   [Go to **Client Certificates**](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls/client-certificates)

2. On the **Hosts** section of the **Client Certificates** card, select **Edit**.

3. Enter the name of a host in your current domain.

Note

The domain (`example.com`) is automatically appended for you. This means that, if you want to enable mTLS for `abc.example.com`, you only need to type `abc`.

1. Select **Save** to confirm.

## CAs in use

As explained in the [Client certificates overview](https://developers.cloudflare.com/ssl/client-certificates/#how-it-works), Cloudflare validates client certificates against CAs set at account level. This means that these certificates can be used for validation across multiple zones/domains (`example.com`), as long as the zones are under the same Cloudflare account and you have enabled mTLS for the host.

Bring your own CA

If you need to use your own CA (instead of the Cloudflare Managed CA), refer to [BYOCA](https://developers.cloudflare.com/ssl/client-certificates/byo-ca/). This is an API-only option, available on Enterprise accounts. In this case, certificates and hostname associations are **not** listed on your dashboard.

## Next steps

After enabling mTLS for your host, you can:

* Enforce mTLS with a WAF custom rule. Select **Create mTLS Rule** on the dashboard to use a template, or refer to our [mTLS at Cloudflare learning path](https://developers.cloudflare.com/learning-paths/mtls/mtls-app-security/#3-validate-the-client-certificate-in-the-waf) for further guidance.
* Enforce mTLS with [API Shield](https://developers.cloudflare.com/api-shield/security/mtls/configure/). While API Shield is **not required** to use mTLS, many teams may use mTLS to protect their APIs.
