---
title: Certification Authority Authorization (CAA) FAQ · Cloudflare SSL/TLS docs
description: The following page answers common questions about Certification
  Authority Authorization (CAA) records.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/edge-certificates/troubleshooting/caa-records/
  md: https://developers.cloudflare.com/ssl/edge-certificates/troubleshooting/caa-records/index.md
---

The following page answers common questions about Certification Authority Authorization (CAA) records.

***

## What is CAA and how can I create one?

A Certificate Authority Authorization (CAA) DNS record specifies which certificate authorities (CAs) are allowed to issue certificates for a domain. This record reduces the chance of unauthorized certificate issuance and promotes standardization across your organization.



For more details, refer to [Create CAA records](https://developers.cloudflare.com/ssl/edge-certificates/caa-records/).

***

## How does Cloudflare evaluate CAA records?

CAA records are evaluated by a CA, not by Cloudflare.

Note

Setting a CAA record to specify one or more particular CAs does not affect which CA(s) Cloudflare uses to issue a Universal or Advanced SSL certificate for your domain.

You can specify CAs associated with Cloudflare certificates when [ordering an advanced certificate](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/manage-certificates/).

***

## What are the dangers of setting CAA records?

If you are part of a large organization or one where multiple parties are tasked with obtaining SSL certificates, [include CAA records](https://developers.cloudflare.com/ssl/edge-certificates/caa-records/) that allow issuance for all CAs applicable for your organization. Failure to do so can inadvertently block SSL issuance for other parts of your organization.

***

## What CAA records are added by Cloudflare?

Cloudflare adds CAA records automatically in the following situations:

* When you have [Universal SSL](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/) and add any CAA records to your zone.
* When you have [advanced certificates](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/) and add any CAA records to your zone.

These records make sure Cloudflare can still issue Universal certificates on your behalf.

If Cloudflare has automatically added CAA records on your behalf, these records will not appear in the Cloudflare dashboard. However, if you run a command line query using `dig`, you can see any existing CAA records, including those added by Cloudflare (replacing `example.com` with your own domain on Cloudflare):

```bash
➜  ~ dig example.com caa +short


# CAA records added by Google Trust Services
0 issue "pki.goog; cansignhttpexchanges=yes"
0 issuewild "pki.goog; cansignhttpexchanges=yes"


# CAA records added by Let's Encrypt
0 issue "letsencrypt.org"
0 issuewild "letsencrypt.org"


# CAA records added by SSL.com
0 issue "ssl.com"
0 issuewild "ssl.com"


# CAA records added by Sectigo
0 issue "sectigo.com"
0 issuewild "sectigo.com"
```

Note

This list is not exhaustive, and other CAs might be added or removed for operational reasons.
