---
title: Encryption modes · Cloudflare SSL/TLS docs
description: Encryption modes allow you to control how Cloudflare connects to
  your origin web server and how certificates presented by your origin are
  validated.
lastUpdated: 2025-09-18T10:37:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/
  md: https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/index.md
---

Your zone's **SSL/TLS Encryption Mode** controls how Cloudflare manages two connections: one between your visitors and Cloudflare, and the other between Cloudflare and your origin server.

```mermaid
flowchart LR
    accTitle: SSL/TLS Encryption mode
    A[Browser] <--Connection 1--> B((Cloudflare))<--Connection 2--> C[(Origin server)]
```



If possible, Cloudflare strongly recommends using [**Full**](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full/) or [**Full (strict)**](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full-strict/) modes to prevent malicious connections to your origin.

For more details on how encryption modes fit into the bigger picture of Cloudflare SSL/TLS protection, refer to [Concepts](https://developers.cloudflare.com/ssl/concepts/#ssltls-certificate).

## Available encryption modes

[Automatic SSL/TLS](#automatic-ssltls-default) relies on the probes developed for the SSL/TLS Recommender to determine what encryption mode is the most secure and safest for a website to be set to. If there is a more secure option for your website (based on your origin certification or capabilities), Automatic SSL/TLS will find it and apply it for your domain. The other option, [Custom SSL/TLS](#custom-ssltls), will work exactly like the setting the encryption mode does today.

Note

We are gradually rolling out the new [Automated SSL/TLS feature](#automatic-ssltls-default).

If your zone has not been migrated yet, you will only have [Custom SSL/TLS](#custom-ssltls) options in your dashboard.

To understand how the various encryption modes affect your cache, refer to the section on [Impact of SSL setting on cache behavior](https://developers.cloudflare.com/cache/how-to/cache-keys/#impact-of-ssl-settings-on-cache-behavior).

### Automatic SSL/TLS (default)

Automatic SSL/TLS leverages advanced methods developed by the SSL/TLS Recommender to select the most secure encryption mode for your website. The Recommender crawls your site using the Cloudflare-SSLDetector user agent, recognized as a trusted bot by Cloudflare, and bypasses `robots.txt` rules (except those that specifically target it) to ensure accuracy. It downloads content from your origin server over both HTTP and HTTPS, then applies a content similarity algorithm to assess consistency. By understanding your current SSL/TLS encryption mode and evaluating your origin's certification and capabilities, the Recommender can automatically adjust settings to maintain the highest security for your domain.

Note

Automatic SSL/TLS will not change your setting to a less secure encryption mode. For example, if your origin certificate expires, the encryption mode will not change from **Full (strict)** to **Full**. You must ensure the validity of your origin SSL/TLS configuration at all times.

Automatic upgrades are applied gradually. Automatic SSL/TLS begins to upgrade the domain by starting with just 1% of its traffic. If no issues are found, the new SSL/TLS encryption mode is applied to traffic in 10% increments until 100% of traffic uses the recommended mode. If origin connectivity fails during this process, Cloudflare aborts the upgrade, immediately rolls traffic back to the previous mode, and logs the failure. Once 100% of traffic has been successfully upgraded with no TLS-related errors, the domain's SSL/TLS setting is permanently updated.

Flexible → Full/Strict transitions are handled with extra caution since the origin scheme change (HTTP → HTTPS) alters cache keys. In this case, the ramp-up may proceed more slowly to allow cache warm-up before resuming standard increments.

#### Additional details

* **Scan frequency**: Automatic scans currently occur approximately once per month, though they may happen more frequently in some cases (for example, configuration changes or upgrades). Scans stop when:

  * The site is already using the most secure mode (for example, **Full (strict)**), or
  * You switch from auto mode to **Custom SSL/TLS**.

* **Error checking before upgrades**: To prevent disruptions, Cloudflare checks for `5XX` errors (like `502` or `503`) and evaluates whether the HTTP and HTTPS content is consistent before upgrading a zone's encryption mode.

* **Upgrade notifications**: Cloudflare sends weekly digest emails listing which zones have been upgraded. These emails are currently sent to Super Admins only.

#### Opt out single zone

If you want to opt a zone out via the API, you can make this API call on or before the grace period expiration date.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Zone Settings Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/settings/ssl_automatic_mode" \
  --request PATCH \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "value": "custom"
  }'
```

#### Opt out multiple zones

If you wanted to opt out multiple zones:

1. Create an API token with the following permissions:

   * `Zone - Zone - Read`
   * `Zone - Zone Settings - Read`
   * `Zone - Zone Settings - Edit`

2. Make a [`GET` request](https://developers.cloudflare.com/api/resources/zones/methods/list/) to get a list of zones (you can filter this list by `account.id`).

   ```bash
   curl 'https://api.cloudflare.com/client/v4/zones?account.id=<ACCOUNT_ID>' \
   --header 'Authorization: Bearer <CF_API_TOKEN>' \
   --header 'Content-Type: application/json'
   ```

3. Create a list of zone IDs you want to opt-out with each zone ID on a separate line (newline separate), stored in a file such as `zones.txt`.

4. Create a bash script for `opt-out-multiple-zones.sh` and add the following. Add `zones.txt` to the same directory or update the path accordingly.

   ```bash
   for zoneID in $(cat zone.txt); do
     printf "Opting out ${zoneID}:\n"


     curl --request PATCH \
       --url https://api.cloudflare.com/client/v4/zones/$zoneID/settings/ssl_automatic_mode \
       --header 'Authorization: Bearer <CF_API_TOKEN>' \
       --header 'Content-Type: application/json' \
       --data '{"value":"custom"}'


     printf "\n\n"
   done
   ```

5. Open your command line and run:

   ```bash
   bash opt-out-multiple-zones.sh
   ```

### Custom SSL/TLS

To use Custom SSL/TLS, select the custom option (if you prefer to manually set the encryption mode instead of using [Automatic SSL/TLS](#automatic-ssltls-default)):

* [Off (no encryption) ](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/off/): No encryption is used for traffic between browsers and Cloudflare or between Cloudflare and origins. Everything is cleartext HTTP.
* [Flexible ](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/flexible/): Traffic from browsers to Cloudflare can be encrypted via HTTPS, but traffic from Cloudflare to the origin server is not. This mode is common for origins that do not support TLS, though upgrading the origin configuration is recommended whenever possible.
* [Full ](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full/): Cloudflare matches the browser request protocol when connecting to the origin. If the browser uses HTTP, Cloudflare connects to the origin via HTTP; if HTTPS, Cloudflare uses HTTPS without validating the origin’s certificate. This mode is common for origins that use self-signed or otherwise invalid certificates.
* [Full (strict) ](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full-strict/): Similar to Full Mode, but with added validation of the origin server’s certificate, which can be issued by a public CA like Let’s Encrypt or by Cloudflare Origin CA.
* [Strict (SSL-Only Origin Pull) ](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/ssl-only-origin-pull/): Regardless of whether the browser-to-Cloudflare connection uses HTTP or HTTPS, Cloudflare always connects to the origin over HTTPS with certificate validation.

## Update your encryption mode

* Dashboard

  To change your encryption mode in the dashboard:

  1. In the Cloudflare dashboard, go to the **SSL/TLS Overview** page.

     [Go to **Overview**](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls)

  2. Choose an encryption mode.

* API

  To adjust your encryption mode with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) request with `ssl` as the setting name in the URI path, and the `value` parameter set to your desired setting (`off`, `flexible`, `full`, `strict`, or `origin_pull`).

Note

To use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/).
