---
title: Badges · Cloudflare Style Guide
description: Badges are a built-in component provided by Starlight. Use them to
  indicate a product is in beta, for example.
lastUpdated: 2025-02-24T12:12:40.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/badges/
  md: https://developers.cloudflare.com/style-guide/components/badges/index.md
---

Badges are a built-in component provided by [Starlight](https://starlight.astro.build/components/badges/). Use them to indicate a product is in beta, for example.

## Component

To adopt this styling in a React component, apply the `sl-badge` class to a `span` element.

## Sidebar

Badges can be added to the sidebar via page frontmatter.

```mdx
---
title: Hello World
sidebar:
  badge:
    variant: tip
    text: New
---
```

If you want to add the Beta badge to a product, omit the `variant:` entry:

```mdx
---
title: Hello World
sidebar:
  badge:
    text: Beta
---
```
